/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.domain;

import java.util.Date;
import org.ict4h.atomfeed.client.domain.Event;

public class FailedEvent {
    private long failedAt;
    private Event event;
    private String errorMessage;
    private String feedUri;
    private int retries;

    public FailedEvent(String feedUri, Event event, String errorMessage, int retries) {
        if (feedUri == null || feedUri.trim().equals("") || event == null) {
            throw new IllegalArgumentException("Arguments provided should not be null.");
        }
        this.event = event;
        this.errorMessage = errorMessage;
        this.feedUri = feedUri;
        this.failedAt = new Date().getTime();
        this.retries = retries;
    }

    public FailedEvent(String feedUri, Event event, String errorMessage, long failedAt, int retries) {
        this(feedUri, event, errorMessage, retries);
        this.failedAt = failedAt;
    }

    public long getFailedAt() {
        return this.failedAt;
    }

    public Event getEvent() {
        return this.event;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFeedUri() {
        return this.feedUri;
    }

    public String getEventId() {
        return this.event.getId();
    }

    public void setFailedAt(long failedAt) {
        this.failedAt = failedAt;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void incrementRetryCount() {
        ++this.retries;
    }

    public String toString() {
        return String.format("FailedEvent{failedAt=%d, event=%s, errorMessage='%s', feedUri='%s'}", this.failedAt, this.event, this.errorMessage, this.feedUri);
    }
}

