/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.domain;

import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Event {
    private List categories = new ArrayList();
    private String id;
    private String content;
    private String feedUri;
    private Date updatedDate;
    private String title;
    private Date dateCreated;

    public Event(Entry entry) {
        this(entry, null);
    }

    public Event(String id, String content) {
        this(id, content, null, null, null);
    }

    public Event(String id, String content, String title) {
        this(id, content, title, null, null);
    }

    public Event(String id, String content, String title, String feedUri, Date updatedDate) {
        this.id = id;
        this.content = content;
        this.title = title;
        this.feedUri = feedUri;
        this.updatedDate = updatedDate;
    }

    public Event(Entry entry, String feedUri) {
        this(entry.getId(), Event.extractContent(entry), entry.getTitle(), feedUri, entry.getUpdated());
        this.categories = entry.getCategories();
        this.dateCreated = entry.getCreated();
    }

    private static String extractContent(Entry entry) {
        if (entry.getContents().isEmpty()) {
            return null;
        }
        String value = ((Content)entry.getContents().get(0)).getValue();
        return value.replaceFirst("^<!\\[CDATA\\[", "").replaceFirst("\\]\\]>$", "");
    }

    public String getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "Event{id='" + this.id + '\'' + ", content='" + this.content + '\'' + '}';
    }

    public String getFeedUri() {
        return this.feedUri;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public List getCategories() {
        return this.categories;
    }

    public Date getDateCreated() {
        return this.dateCreated != null ? this.dateCreated : this.updatedDate;
    }
}

