/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.icij.extract.queue.DocumentQueue;
import org.icij.extract.redis.PathDecoder;
import org.icij.extract.redis.PathEncoder;
import org.icij.extract.redis.RedissonClientFactory;
import org.icij.task.Options;
import org.icij.task.annotation.Option;
import org.icij.task.annotation.OptionsClass;
import org.redisson.Redisson;
import org.redisson.RedissonBlockingQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandSyncService;
import org.redisson.liveobject.core.RedissonObjectBuilder;

@org.icij.task.annotation.Options(value={@Option(name="queueName", description="The name of the queue.", parameter="name"), @Option(name="charset", description="Set the output encoding for strings. Defaults to UTF-8.", parameter="name")})
@OptionsClass(value=RedissonClientFactory.class)
public class RedisDocumentQueue
extends RedissonBlockingQueue<Path>
implements DocumentQueue {
    private static final String DEFAULT_NAME = "extract:queue";
    private final RedissonClient redissonClient;

    public RedisDocumentQueue(final String queueName, final String redisAddress) {
        this(Options.from((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("redisAddress", redisAddress);
                this.put("queueName", queueName);
            }
        }));
    }

    public RedisDocumentQueue(Options<String> options) {
        this(new RedissonClientFactory().withOptions(options).create(), options.valueIfPresent("queueName").orElse(DEFAULT_NAME), Charset.forName(options.valueIfPresent("charset").orElse("UTF-8")));
    }

    private RedisDocumentQueue(RedissonClient redissonClient, String name, Charset charset) {
        this((Codec)new PathQueueCodec(charset), (CommandAsyncExecutor)new CommandSyncService(((Redisson)redissonClient).getConnectionManager(), new RedissonObjectBuilder(redissonClient)), null == name ? DEFAULT_NAME : name, redissonClient);
    }

    private RedisDocumentQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
        this.redissonClient = redisson;
    }

    @Override
    public boolean remove(Object o, int count) {
        return super.remove(o, count);
    }

    @Override
    public void close() throws IOException {
        this.redissonClient.shutdown();
    }

    public String toString() {
        return "RedisDocumentQueue{name=" + this.getName() + "}";
    }

    static class PathQueueCodec
    extends BaseCodec {
        private final Decoder<Object> pathDecoder;
        private final Encoder documentEncoder;

        PathQueueCodec(Charset charset) {
            this.pathDecoder = new PathDecoder(charset);
            this.documentEncoder = new PathEncoder(charset);
        }

        public Decoder<Object> getValueDecoder() {
            return this.pathDecoder;
        }

        public Decoder<Object> getMapValueDecoder() {
            return this.pathDecoder;
        }

        public Decoder<Object> getMapKeyDecoder() {
            return this.pathDecoder;
        }

        public Encoder getMapValueEncoder() {
            return this.documentEncoder;
        }

        public Encoder getMapKeyEncoder() {
            return this.documentEncoder;
        }

        public Encoder getValueEncoder() {
            return this.documentEncoder;
        }
    }
}

