/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ErrorParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FallbackParser
extends AbstractParser {
    public static Parser INSTANCE = new FallbackParser();
    private static final long serialVersionUID = 2962493551622366449L;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.emptySet();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, IOException, TikaException {
        ErrorParser parser;
        long size;
        String value = metadata.get("Content-Length");
        if (null != value && !value.isEmpty()) {
            size = Long.valueOf(value);
        } else {
            try (TikaInputStream tis = TikaInputStream.get((InputStream)stream);){
                size = tis.getLength();
            }
            metadata.set("Content-Length", Long.toString(size));
        }
        if (size > 0L) {
            parser = ErrorParser.INSTANCE;
        } else {
            metadata.set("Content-Type", "application/octet-stream");
            parser = EmptyParser.INSTANCE;
        }
        parser.parse(stream, handler, metadata, context);
    }
}

