/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.extractor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.function.Function;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.utils.ExceptionUtils;
import org.icij.extract.document.EmbeddedTikaDocument;
import org.icij.extract.document.TikaDocument;
import org.icij.extract.extractor.EmbedParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EmbedSpawner
extends EmbedParser {
    private static final Logger logger = LoggerFactory.getLogger(EmbedParser.class);
    private final Path outputPath;
    private final Function<Writer, ContentHandler> handlerFunction;
    private final LinkedList<TikaDocument> tikaDocumentStack = new LinkedList();
    private int untitled = 0;

    EmbedSpawner(TikaDocument root, ParseContext context, Path outputPath, Function<Writer, ContentHandler> handlerFunction) {
        super(root, context);
        this.outputPath = outputPath;
        this.handlerFunction = handlerFunction;
        this.tikaDocumentStack.add(root);
    }

    @Override
    public void parseEmbedded(InputStream input, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
        if (TikaCoreProperties.EmbeddedResourceType.INLINE.toString().equals(metadata.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE))) {
            EmbeddedContentHandler embedHandler = new EmbeddedContentHandler((ContentHandler)new BodyContentHandler(handler));
            if (outputHtml) {
                this.writeStart(handler, metadata);
            }
            this.delegateParsing(input, (ContentHandler)embedHandler, metadata);
            if (outputHtml) {
                this.writeEnd(handler);
            }
        } else {
            this.spawnEmbedded(TikaInputStream.get((InputStream)input), metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spawnEmbedded(TikaInputStream tis, Metadata metadata) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8);
        ContentHandler embedHandler = this.handlerFunction.apply(writer);
        EmbeddedTikaDocument embed = this.tikaDocumentStack.getLast().addEmbed(metadata);
        embed.setReader(() -> new InputStreamReader((InputStream)new ByteArrayInputStream(output.toByteArray()), StandardCharsets.UTF_8));
        String name = metadata.get("resourceName");
        if (null == name || name.isEmpty()) {
            name = String.format("untitled_%d", ++this.untitled);
        }
        try {
            if (null != this.outputPath) {
                tis.getPath();
            }
        }
        catch (Exception e) {
            logger.error("Unable to spool file to disk (\"{}\" in \"{}\").", new Object[]{name, this.root, e});
            this.tikaDocumentStack.getLast().removeEmbed(embed);
            embed.clearReader();
            ((Writer)writer).close();
            return;
        }
        this.tikaDocumentStack.add(embed);
        try {
            this.delegateParsing((InputStream)tis, embedHandler, metadata);
        }
        catch (Exception e) {
            logger.error("Unable to parse embedded document: \"{}\" ({}) (in \"{}\").", new Object[]{name, metadata.get("Content-Type"), this.root, e});
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_EMBEDDED_STREAM, ExceptionUtils.getFilteredStackTrace((Throwable)e));
        }
        finally {
            this.tikaDocumentStack.removeLast();
            ((Writer)writer).close();
        }
        if (null != this.outputPath) {
            this.writeEmbed(tis, embed, name);
        }
    }

    private void writeEmbed(TikaInputStream tis, EmbeddedTikaDocument embed, String name) throws IOException {
        Path source;
        Metadata metadata;
        Path destination;
        block21: {
            destination = this.outputPath.resolve(embed.getHash());
            metadata = embed.getMetadata();
            Object container = tis.getOpenContainer();
            if (container instanceof DirectoryEntry) {
                try (TemporaryResources tmp = new TemporaryResources();
                     POIFSFileSystem fs = new POIFSFileSystem();){
                    source = tmp.createTempFile();
                    this.saveEntries((DirectoryEntry)container, (DirectoryEntry)fs.getRoot());
                    try (OutputStream output = Files.newOutputStream(source, new OpenOption[0]);){
                        fs.writeFilesystem(output);
                        break block21;
                    }
                }
            }
            source = tis.getPath();
        }
        if (null == metadata.get("Content-Length")) {
            metadata.set("Content-Length", Long.toString(Files.size(source)));
        }
        try {
            Files.copy(source, destination, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException e) {
            if (Files.size(source) != Files.size(destination)) {
                Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            logger.info("Temporary file for document \"{}\" in \"{}\" already exists.", (Object)name, (Object)this.root);
        }
    }

    private void saveEntries(DirectoryEntry source, DirectoryEntry destination) throws IOException {
        for (Entry entry : source) {
            if (entry instanceof DirectoryEntry) {
                this.saveEntries((DirectoryEntry)entry, destination.createDirectory(entry.getName()));
                continue;
            }
            try (DocumentInputStream contents = new DocumentInputStream((DocumentEntry)entry);){
                destination.createDocument(entry.getName(), (InputStream)contents);
            }
        }
    }
}

