/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.extractor;

import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.icij.concurrent.BlockingThreadPoolExecutor;
import org.icij.concurrent.ExecutorProxy;
import org.icij.extract.extractor.Extractor;
import org.icij.extract.report.Reporter;
import org.icij.spewer.Spewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentConsumer
extends ExecutorProxy
implements Consumer<Path> {
    private static final Logger logger = LoggerFactory.getLogger(DocumentConsumer.class);
    protected final Spewer spewer;
    protected final Extractor extractor;
    private Reporter reporter = null;

    public static int defaultPoolSize() {
        return Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
    }

    public DocumentConsumer(Spewer spewer, Extractor extractor, ExecutorService executor) {
        super(executor);
        this.spewer = spewer;
        this.extractor = extractor;
    }

    public DocumentConsumer(Spewer spewer, Extractor extractor, int poolSize) {
        this(spewer, extractor, new BlockingThreadPoolExecutor(poolSize));
    }

    public DocumentConsumer(Spewer spewer, Extractor extractor) {
        this(spewer, extractor, DocumentConsumer.defaultPoolSize());
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    @Override
    public void accept(Path path) {
        logger.info(String.format("Sending to thread pool; will queue if full: \"%s\".", path));
        this.executor.execute(() -> {
            logger.info(String.format("Beginning extraction: \"%s\".", path));
            try {
                if (null != this.reporter) {
                    this.extractor.extract(path, this.spewer, this.reporter);
                } else {
                    this.extractor.extract(path, this.spewer);
                }
            }
            catch (Exception e) {
                logger.error(String.format("Exception while consuming file: \"%s\".", path), (Throwable)e);
            }
        });
    }
}

