/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.document;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.icij.extract.document.EmbeddedTikaDocument;
import org.icij.extract.document.Identifier;

public class TikaDocument {
    public static String CONTENT_ENCODING = "Content-Encoding";
    public static String CONTENT_LANGUAGE = "Content-Language";
    public static String CONTENT_LENGTH = "Content-Length";
    public static String CONTENT_LOCATION = "Content-Location";
    public static String CONTENT_DISPOSITION = "Content-Disposition";
    public static String CONTENT_MD5 = "Content-MD5";
    public static String CONTENT_TYPE = "Content-Type";
    public static Property LAST_MODIFIED = Property.internalDate((String)"Last-Modified");
    public static String LOCATION = "Location";
    private final Path path;
    private Supplier<String> id;
    private String language = null;
    private String foreignId = null;
    private final Metadata metadata;
    private Identifier identifier;
    private List<EmbeddedTikaDocument> embeds = new LinkedList<EmbeddedTikaDocument>();
    private Map<String, EmbeddedTikaDocument> lookup = new HashMap<String, EmbeddedTikaDocument>();
    private Reader reader = null;
    private ReaderGenerator readerGenerator = null;

    public TikaDocument(String id, Identifier identifier, Path path, String language, Metadata metadata) {
        Objects.requireNonNull(path, "The path must not be null.");
        this.metadata = metadata;
        this.path = path;
        this.identifier = identifier;
        this.language = language;
        this.id = () -> id;
    }

    public TikaDocument(String id, Identifier identifier, Path path, Metadata metadata) {
        Objects.requireNonNull(path, "The path must not be null.");
        this.metadata = metadata;
        this.path = path;
        this.identifier = identifier;
        this.id = () -> id;
    }

    public TikaDocument(String id, Identifier identifier, Path path) {
        this(id, identifier, path, new Metadata());
    }

    public TikaDocument(String id, Identifier identifier, Path path, String language) {
        this(id, identifier, path, language, new Metadata());
    }

    public TikaDocument(Identifier identifier, Path path, Metadata metadata) {
        Objects.requireNonNull(identifier, "The identifier generator must not be null.");
        Objects.requireNonNull(path, "The path must not be null.");
        if (metadata.get("resourceName") == null) {
            metadata.add("resourceName", path.toFile().getName());
        }
        this.metadata = metadata;
        this.path = path;
        this.identifier = identifier;
        this.id = () -> {
            String id;
            try {
                id = this.generateId();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to generate document ID.", e);
            }
            this.id = () -> id;
            return id;
        };
    }

    public TikaDocument(Identifier identifier, Path path, String language, Metadata metadata) {
        this(identifier, path, metadata);
        this.language = language;
    }

    public TikaDocument(Identifier identifier, Path path) {
        this(identifier, path, new Metadata());
    }

    public TikaDocument(Identifier identifier, Path path, String language) {
        this(identifier, path, language, new Metadata());
    }

    String generateId() throws Exception {
        return this.identifier.generate(this);
    }

    public String getId() {
        return this.id.get();
    }

    public String getLanguage() {
        return this.language;
    }

    public String getHash() {
        return this.identifier.retrieveHash(this.getMetadata());
    }

    Identifier getIdentifier() {
        return this.identifier;
    }

    public Path getPath() {
        return this.path;
    }

    public String getMetadata(String fieldName) {
        return this.metadata.get(fieldName);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public EmbeddedTikaDocument addEmbed(Metadata metadata) {
        return this.addEmbed(new EmbeddedTikaDocument(this, metadata));
    }

    private EmbeddedTikaDocument addEmbed(Identifier identifier, Path path, Metadata metadata) {
        return this.addEmbed(new EmbeddedTikaDocument(this, identifier, path, metadata));
    }

    public EmbeddedTikaDocument addEmbed(String key, Identifier identifier, Path path, Metadata metadata) {
        return this.lookup.put(key, this.addEmbed(identifier, path, metadata));
    }

    private EmbeddedTikaDocument addEmbed(EmbeddedTikaDocument embed) {
        this.embeds.add(embed);
        return embed;
    }

    public boolean removeEmbed(EmbeddedTikaDocument embed) {
        return this.embeds.remove(embed);
    }

    public List<EmbeddedTikaDocument> getEmbeds() {
        return this.embeds;
    }

    public boolean hasEmbeds() {
        return !this.embeds.isEmpty();
    }

    public EmbeddedTikaDocument getEmbed(String key) {
        return this.lookup.get(key);
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void setReader(ReaderGenerator readerGenerator) {
        this.readerGenerator = readerGenerator;
    }

    public void clearReader() {
        this.reader = null;
        this.readerGenerator = null;
    }

    public void setForeignId(String foreignId) {
        this.foreignId = foreignId;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public synchronized Reader getReader() throws IOException {
        if (null == this.reader && null != this.readerGenerator) {
            this.reader = this.readerGenerator.generate();
        }
        return this.reader;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TikaDocument)) {
            return false;
        }
        String id = this.getId();
        return null != id && id.equals(((TikaDocument)other).getId());
    }

    public int hashCode() {
        return Objects.hash(this.id.get());
    }

    public void apply(Consumer<TikaDocument> consumer) {
        consumer.accept(this);
        for (EmbeddedTikaDocument doc : this.getEmbeds()) {
            doc.apply(consumer);
        }
    }

    public String toString() {
        return this.path.toString() + " - " + this.getMetadata("resourceName");
    }

    @FunctionalInterface
    public static interface ReaderGenerator {
        public Reader generate() throws IOException;
    }
}

