/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.cleaner;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.icij.extract.cleaner.CleanContext;
import org.icij.extract.cleaner.Cleaner;
import org.icij.extract.cleaner.ContentCleaner;
import org.icij.extract.cleaner.DocumentSource;

public class MetadataCleaner {
    private final ContentCleaner cleaner = new ContentCleaner(Arrays.asList(new PdfMetadataCleaner(), new OfficeWordMetadataCleaner()));

    public DocumentSource clean(Path document) throws IOException {
        return this.clean(new FileInputStream(document.toFile()));
    }

    public DocumentSource clean(InputStream inputStream) throws IOException {
        CleanContext context = new CleanContext();
        context.set(Cleaner.class, this.cleaner);
        DocumentSource documentSource = new DocumentSource();
        Metadata metadata = new Metadata();
        this.cleaner.clean(inputStream, documentSource, metadata, context);
        return documentSource;
    }

    static class InternalCleanerException
    extends RuntimeException {
        public InternalCleanerException(Exception e) {
            super(e);
        }
    }

    public static class OfficeWordMetadataCleaner
    implements Cleaner {
        @Override
        public Set<MediaType> getSupportedTypes(CleanContext context) {
            return MediaType.set((String[])new String[]{"application/msword"});
        }

        @Override
        public void clean(InputStream stream, DocumentSource documentSource, Metadata metadata, CleanContext context) throws IOException {
            HWPFDocument document = new HWPFDocument(stream);
            this.removeSummaryInformationMetadata(document.getSummaryInformation());
            document.write((OutputStream)documentSource.getOutputStream());
        }

        private void removeSummaryInformationMetadata(SummaryInformation summaryInformation) {
            List<Method> methods = Arrays.stream(summaryInformation.getClass().getMethods()).filter(method -> method.getName().startsWith("remove")).collect(Collectors.toList());
            methods.forEach(method -> {
                try {
                    method.invoke((Object)summaryInformation, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new InternalCleanerException(e);
                }
            });
        }
    }

    public static class PdfMetadataCleaner
    implements Cleaner {
        @Override
        public Set<MediaType> getSupportedTypes(CleanContext context) {
            return MediaType.set((String[])new String[]{"application/pdf"});
        }

        @Override
        public void clean(InputStream stream, DocumentSource documentSource, Metadata metadata, CleanContext context) throws IOException {
            PDDocument document = PDDocument.load((InputStream)stream);
            PDDocumentInformation information = document.getDocumentInformation();
            document.getDocumentCatalog().setMetadata(null);
            if (information != null) {
                document.setDocumentInformation(new PDDocumentInformation());
                document.save((OutputStream)documentSource.getOutputStream());
            }
            document.close();
        }
    }
}

