/*
 * Decompiled with CFR 0.152.
 */
package org.icij.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final long maximumBlockingTime;
    private final TimeUnit maximumBlockingUnit;
    private final AtomicInteger tasksInProcess = new AtomicInteger();
    private final Semaphore permits;
    private final Synchronizer synchronizer = new Synchronizer();

    public BlockingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, long maximumBlockingTime, TimeUnit maximumBlockingUnit) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.permits = new Semaphore(maximumPoolSize);
        this.maximumBlockingTime = maximumBlockingTime;
        this.maximumBlockingUnit = maximumBlockingUnit;
    }

    public BlockingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy(), 0L, TimeUnit.MILLISECONDS);
    }

    public BlockingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
    }

    public BlockingThreadPoolExecutor(int poolSize) {
        this(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void execute(Runnable task) {
        try {
            if (this.maximumBlockingTime > 0L) {
                if (!this.permits.tryAcquire(this.maximumBlockingTime, this.maximumBlockingUnit)) {
                    throw new RejectedExecutionException(String.format("Unable to acquire a permit in %d %s.", new Object[]{this.maximumBlockingTime, this.maximumBlockingUnit}));
                }
            } else {
                this.permits.acquire();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException("The thread was interrupted before task could be submitted for execution.", e);
        }
        this.tasksInProcess.incrementAndGet();
        try {
            super.execute(task);
        }
        catch (RejectedExecutionException e) {
            this.tasksInProcess.decrementAndGet();
            this.permits.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        BlockingThreadPoolExecutor blockingThreadPoolExecutor = this;
        synchronized (blockingThreadPoolExecutor) {
            this.tasksInProcess.decrementAndGet();
            this.permits.release();
            if (this.tasksInProcess.intValue() == 0) {
                this.synchronizer.signalAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0) {
            throw new IllegalArgumentException("Maximum pool size must be greater than zero.");
        }
        BlockingThreadPoolExecutor blockingThreadPoolExecutor = this;
        synchronized (blockingThreadPoolExecutor) {
            int delta = maximumPoolSize - this.getMaximumPoolSize();
            if (delta > 0) {
                this.permits.release(delta - this.tasksInProcess.get());
            } else if (delta < 0) {
                delta = Math.abs(delta);
                try {
                    if (this.maximumBlockingTime > 0L) {
                        if (!this.permits.tryAcquire(delta, this.maximumBlockingTime, this.maximumBlockingUnit)) {
                            throw new RuntimeException(String.format("Unable to acquire %d permits in %d %s.", new Object[]{delta, this.maximumBlockingTime, this.maximumBlockingUnit}));
                        }
                    } else {
                        this.permits.acquire(delta);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            super.setMaximumPoolSize(maximumPoolSize);
        }
    }

    public void await() throws InterruptedException {
        this.synchronizer.await();
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.synchronizer.await(timeout, timeUnit);
    }

    private class Synchronizer {
        private final Lock lock = new ReentrantLock();
        private final Condition done = this.lock.newCondition();
        private boolean isDone = false;

        private Synchronizer() {
        }

        private void signalAll() {
            this.lock.lock();
            try {
                this.isDone = true;
                this.done.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void await() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.isDone) {
                    this.done.await();
                }
            }
            finally {
                this.isDone = false;
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
            boolean isDone;
            boolean result = false;
            this.lock.lock();
            try {
                result = this.done.await(timeout, timeUnit);
            }
            finally {
                isDone = this.isDone;
                this.isDone = false;
                this.lock.unlock();
            }
            return result && isDone;
        }
    }
}

