/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.cli;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.RegexMatcher;
import org.icij.datashare.cli.DigestAlgorithm;
import org.icij.datashare.cli.Mode;
import org.icij.datashare.cli.QueueType;

public final class DatashareCliOptions {
    public static final char ARG_VALS_SEP = ',';
    private static final Integer DEFAULT_PARSER_PARALLELISM = 1;
    private static final Integer DEFAULT_NLP_PARALLELISM = 1;
    private static final Integer DEFAULT_PARALLELISM = Runtime.getRuntime().availableProcessors() == 1 ? 2 : Runtime.getRuntime().availableProcessors();
    public static final String STAGES_OPT = "stages";
    public static final String DATA_DIR_OPT = "dataDir";
    public static final String NLP_PIPELINES_OPT = "nlpPipelines";
    public static final String BATCH_THROTTLE = "batchThrottleMilliseconds";
    public static final String BATCH_SEARCH_MAX_TIME = "batchSearchMaxTimeSeconds";
    public static final String BATCH_DOWNLOAD_ZIP_TTL = "batchDownloadTimeToLive";
    public static final String SCROLL_SIZE = "scrollSize";
    public static final String BATCH_DOWNLOAD_MAX_NB_FILES = "batchDownloadMaxNbFiles";
    public static final String BATCH_DOWNLOAD_MAX_SIZE = "batchDownloadMaxSize";
    public static final String BATCH_DOWNLOAD_DIR = "batchDownloadDir";
    static final String MESSAGE_BUS_OPT = "messageBusAddress";
    static final String ROOT_HOST = "rootHost";
    public static final String RESUME_OPT = "resume";
    public static final String GET_API_KEY_OPT = "apiKey";
    public static final String CREATE_INDEX_OPT = "createIndex";
    public static final String CRE_API_KEY_OPT = "createApiKey";
    public static final String PLUGIN_LIST_OPT = "pluginList";
    public static final String PLUGIN_INSTALL_OPT = "pluginInstall";
    public static final String PLUGIN_DELETE_OPT = "pluginDelete";
    public static final String EXTENSION_LIST_OPT = "extensionList";
    public static final String EXTENSION_INSTALL_OPT = "extensionInstall";
    public static final String EXTENSION_DELETE_OPT = "extensionDelete";
    public static final String DEL_API_KEY_OPT = "deleteApiKey";
    public static final String PARALLELISM = "parallelism";
    public static final String OPEN_LINK = "browserOpenLink";
    public static final String NLP_PARALLELISM_OPT = "nlpParallelism";
    public static final String EMBEDDED_DOCUMENT_DOWNLOAD_MAX_SIZE = "embeddedDocumentDownloadMaxSize";
    public static final String DEFAULT_EMBEDDED_DOCUMENT_DOWNLOAD_MAX_SIZE = "1G";
    public static final String DEFAULT_USER_NAME = "defaultUserName";
    public static final String DEFAULT_BATCH_DOWNLOAD_DIR = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("app/tmp").toString();
    public static final String DEFAULT_BATCH_DOWNLOAD_MAX_SIZE = "100M";
    public static final int DEFAULT_BATCH_DOWNLOAD_MAX_NB_FILES = 10000;
    public static final int DEFAULT_BATCH_DOWNLOAD_ZIP_TTL = 24;
    public static final String DIGEST_ALGORITHM_OPT = "digestAlgorithm";
    public static final String DIGEST_PROJECT_NAME = "digestProjectName";
    public static final String DEFAULT_PROJECT = "defaultProject";
    public static final String NO_DIGEST_PROJECT = "noDigestProject";

    static void stages(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(STAGES_OPT), "Stages to be run. WARN that DEDUPLICATE stages are not streamable like the others. They should be run alone.").withRequiredArg().ofType(String.class);
    }

    static void mode(OptionParser parser) {
        parser.acceptsAll(Arrays.asList("mode", "m"), "Datashare run mode " + Arrays.toString((Object[])Mode.values())).withRequiredArg().ofType(Mode.class).defaultsTo((Object)Mode.LOCAL, (Object[])new Mode[0]);
    }

    static void defaultUser(OptionParser parser) {
        parser.acceptsAll(Arrays.asList("u", DEFAULT_USER_NAME), "Default local user name").withRequiredArg().ofType(String.class).defaultsTo((Object)"local", (Object[])new String[0]);
    }

    static void followSymlinks(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("followSymlinks"), "Follow symlinks (default false)");
    }

    static void cors(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("cors"), "CORS headers (needs the web option)").withRequiredArg().ofType(String.class).defaultsTo((Object)"no-cors", (Object[])new String[0]);
    }

    static void settings(OptionParser parser) {
        parser.acceptsAll(Arrays.asList("s", "settings"), "Property settings file").withRequiredArg().ofType(String.class);
    }

    static void pluginsDir(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("pluginsDir"), "Plugins directory").withRequiredArg().ofType(String.class);
    }

    static void pluginList(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(PLUGIN_LIST_OPT), "Plugins list matching provided string").withOptionalArg().ofType(String.class);
    }

    static void pluginInstall(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(PLUGIN_INSTALL_OPT), "Install plugin with either id or URL or file path (needs pluginsDir option)").withRequiredArg().ofType(String.class);
    }

    static void pluginDelete(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(PLUGIN_DELETE_OPT), "Delete plugin with its id or base directory (needs pluginsDir option)").withRequiredArg().ofType(String.class);
    }

    static void extensionList(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(EXTENSION_LIST_OPT), "Extensions list matching provided string").withOptionalArg().ofType(String.class);
    }

    static void extensionInstall(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(EXTENSION_INSTALL_OPT), "Install extension with either id or URL or file path (needs extensionsDir option)").withRequiredArg().ofType(String.class);
    }

    static void extensionDelete(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(EXTENSION_DELETE_OPT), "Delete extension with its id or base directory (needs extensionsDir option)").withRequiredArg().ofType(String.class);
    }

    public static void extensionsDir(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("extensionsDir"), "Extensions directory (backend)").withRequiredArg().ofType(String.class);
    }

    static void tcpListenPort(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("tcpListenPort"), "Port used by the HTTP server").withRequiredArg().ofType(Integer.class).defaultsTo((Object)8080, (Object[])new Integer[0]);
    }

    static void sessionTtlSeconds(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("sessionTtlSeconds"), "Time to live for a HTTP session in seconds").withRequiredArg().ofType(Integer.class).defaultsTo((Object)43200, (Object[])new Integer[0]);
    }

    static void protectedUriPrefix(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("protectedUriPrefix"), "Protected URI prefix").withRequiredArg().ofType(String.class).defaultsTo((Object)"/api/", (Object[])new String[0]);
    }

    static void resume(OptionParser parser) {
        parser.acceptsAll(Arrays.asList(RESUME_OPT, "r"), "Resume pending operations");
    }

    static void createIndex(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(CREATE_INDEX_OPT), "creates an index with the given name").withRequiredArg().ofType(String.class);
    }

    static void genApiKey(OptionParser parser) {
        parser.acceptsAll(Arrays.asList(CRE_API_KEY_OPT, "k"), "Generate and store api key for user defaultUser (see opt)").withRequiredArg().ofType(String.class);
    }

    static void getApiKey(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(GET_API_KEY_OPT), "existing api key for user").withRequiredArg().ofType(String.class);
    }

    static void delApiKey(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(DEL_API_KEY_OPT), "Delete api key for user").withRequiredArg().ofType(String.class);
    }

    static void dataDir(OptionParser parser) {
        parser.acceptsAll(Arrays.asList(DATA_DIR_OPT, "d"), "Document source files directory").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("/home/datashare/data"), (Object[])new File[0]);
    }

    static void rootHost(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(ROOT_HOST), "Datashare host for urls").withRequiredArg();
    }

    static void messageBusAddress(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(MESSAGE_BUS_OPT), "Message bus address").withRequiredArg().defaultsTo((Object)"redis://redis:6379", (Object[])new String[0]);
    }

    public static void busType(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("busType"), "Backend data bus type.").withRequiredArg().ofType(QueueType.class).defaultsTo((Object)QueueType.MEMORY, (Object[])new QueueType[0]);
    }

    static void redisAddress(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("redisAddress"), "Redis queue address").withRequiredArg().defaultsTo((Object)"redis://redis:6379", (Object[])new String[0]);
    }

    static void queueType(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("queueType"), "Backend queues and sets type.").withRequiredArg().ofType(QueueType.class).defaultsTo((Object)QueueType.MEMORY, (Object[])new QueueType[0]);
    }

    static void fileParserParallelism(OptionParser parser) {
        parser.acceptsAll(Arrays.asList("pp", "parserParallelism"), "Number of file parser threads.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)DEFAULT_PARSER_PARALLELISM, (Object[])new Integer[0]);
    }

    static void nlpParallelism(OptionParser parser) {
        parser.acceptsAll(Arrays.asList("np", NLP_PARALLELISM_OPT), "Number of NLP extraction threads per pipeline.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)DEFAULT_NLP_PARALLELISM, (Object[])new Integer[0]);
    }

    public static void batchSearchMaxTime(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(BATCH_SEARCH_MAX_TIME), "Max time for batch search in seconds").withRequiredArg().ofType(Integer.class);
    }

    public static void batchThrottle(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(BATCH_THROTTLE), "Throttle for batch in milliseconds").withRequiredArg().ofType(Integer.class);
    }

    public static void scrollSize(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(SCROLL_SIZE), "Scroll size used for elasticsearch scrolls (SCANIDX task)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)1000, (Object[])new Integer[0]);
    }

    public static void scrollSlices(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("scrollSlices"), "Scroll slice max number used for elasticsearch scrolls (SCANIDX task)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
    }

    public static void redisPoolSize(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("redisPoolSize"), "Redis pool size used for each redis collection").withRequiredArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
    }

    public static void elasticsearchDataPath(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("elasticsearchDataPath"), "Data path used for embedded Elasticsearch").withRequiredArg().ofType(String.class).defaultsTo((Object)"/home/datashare/es", (Object[])new String[0]);
    }

    public static void reportName(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("reportName"), "name of the map for the report map (where index results are stored). No report records are saved if not provided").withRequiredArg().ofType(String.class);
    }

    static void enableBrowserOpenLink(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(OPEN_LINK), "try to open link in the default browser").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
    }

    static void enableOcr(OptionParser parser) {
        parser.acceptsAll(Arrays.asList("ocr", "o"), "Run optical character recognition at file parsing time. (Tesseract must be installed beforehand).").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
    }

    static void language(OptionParser parser) {
        parser.acceptsAll(Arrays.asList("language", "l"), "Explicitly specify language of indexed documents (instead of detecting automatically)").withRequiredArg().ofType(String.class);
    }

    static void ocrLanguage(OptionParser parser) {
        parser.acceptsAll(List.of("ocrLanguage"), "Explicitly specify OCR languages for tesseract. 3-character ISO 639-2 language codes and + sign for multiple languages").withRequiredArg().ofType(String.class);
    }

    static void nlpPipelines(OptionParser parser) {
        parser.acceptsAll(Arrays.asList(NLP_PIPELINES_OPT, "nlpp"), "NLP pipelines to be run.").withRequiredArg().withValuesSeparatedBy(',');
    }

    static void parallelism(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(PARALLELISM), "Number of threads allocated for task management.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)DEFAULT_PARALLELISM, (Object[])new Integer[0]);
    }

    static void esHost(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("elasticsearchAddress"), "Elasticsearch host address").withRequiredArg().ofType(String.class).defaultsTo((Object)"http://elasticsearch:9200", (Object[])new String[0]);
    }

    static void dataSourceUrl(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("dataSourceUrl"), "Datasource URL").withRequiredArg().ofType(String.class).defaultsTo((Object)"jdbc:sqlite:file:memorydb.db?mode=memory&cache=shared", (Object[])new String[0]);
    }

    static void defaultProject(OptionParser parser) {
        parser.acceptsAll(Arrays.asList(DEFAULT_PROJECT, "p"), "Default project name").withRequiredArg().ofType(String.class).defaultsTo((Object)"local-datashare", (Object[])new String[0]);
    }

    static void clusterName(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("clusterName"), "Cluster name").withRequiredArg().ofType(String.class).defaultsTo((Object)"datashare", (Object[])new String[0]);
    }

    static void queueName(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("queueName"), "Extract queue name").withRequiredArg().ofType(String.class).defaultsTo((Object)"extract:queue", (Object[])new String[0]);
    }

    static OptionSpec<Void> help(OptionParser parser) {
        return parser.acceptsAll(Arrays.asList("help", "h", "?")).forHelp();
    }

    static OptionSpec<Void> version(OptionParser parser) {
        return parser.acceptsAll(Arrays.asList("version", "v"));
    }

    static void authUsersProvider(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("authUsersProvider"), "Server mode auth users provider class").withRequiredArg().ofType(String.class);
    }

    static void authFilter(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("authFilter"), "Server mode auth filter class").withRequiredArg().ofType(String.class);
    }

    static void oauthSecret(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("oauthClientSecret"), "OAuth2 client secret key").withRequiredArg().ofType(String.class);
    }

    static void oauthClient(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("oauthClientId"), "OAuth2 client id").withRequiredArg().ofType(String.class);
    }

    static void oauthAuthorizeUrl(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("oauthAuthorizeUrl"), "OAuth2 authorize url").withRequiredArg().ofType(String.class);
    }

    static void oauthTokenUrl(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("oauthTokenUrl"), "OAuth2 token url").withRequiredArg().ofType(String.class);
    }

    static void oauthApiUrl(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("oauthApiUrl"), "OAuth2 api url").withRequiredArg().ofType(String.class);
    }

    static void oauthCallbackPath(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("oauthCallbackPath"), "OAuth2 callback path (in datashare)").withRequiredArg().ofType(String.class);
    }

    public static void batchQueueType(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("batchQueueType"), "").withRequiredArg().ofType(QueueType.class).defaultsTo((Object)QueueType.MEMORY, (Object[])new QueueType[0]);
    }

    public static void batchDownloadTimeToLive(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(BATCH_DOWNLOAD_ZIP_TTL), "Time to live in hour for batch download zip files (Default 24)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)24, (Object[])new Integer[0]);
    }

    public static void batchDownloadMaxNbFiles(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(BATCH_DOWNLOAD_MAX_NB_FILES), "Maximum file number that can be archived in a zip (Default 10,000)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)10000, (Object[])new Integer[0]);
    }

    public static void batchDownloadEncrypt(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("batchDownloadEncrypt"), "Whether Batch download zip files are encrypted or not. SmtpUrl should be set to send the password. (default false)").withRequiredArg().ofType(Boolean.class);
    }

    public static void smtpUrl(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("smtpUrl"), "Smtp url to allow datashare to send emails (ex: smtp://localhost:25)").withRequiredArg().ofType(URI.class);
    }

    public static void embeddedDocumentDownloadMaxSize(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(EMBEDDED_DOCUMENT_DOWNLOAD_MAX_SIZE), "Maximum download size of embedded documents. Human readable suffix K/M/G for KB/MB/GB (Default 1G)").withRequiredArg().withValuesConvertedBy(RegexMatcher.regex((String)"[0-9]+[KMG]?")).defaultsTo((Object)DEFAULT_EMBEDDED_DOCUMENT_DOWNLOAD_MAX_SIZE, (Object[])new String[0]);
    }

    public static void batchDownloadMaxSize(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(BATCH_DOWNLOAD_MAX_SIZE), "Maximum total files size that can be zipped. Human readable suffix K/M/G for KB/MB/GB (Default 100M)").withRequiredArg().withValuesConvertedBy(RegexMatcher.regex((String)"[0-9]+[KMG]?")).defaultsTo((Object)DEFAULT_BATCH_DOWNLOAD_MAX_SIZE, (Object[])new String[0]);
    }

    public static void batchDownloadDir(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(BATCH_DOWNLOAD_DIR), "Directory where Batch Download archives are downloaded. (Default <currentUserDir>/app/tmp").withRequiredArg().ofType(String.class).defaultsTo((Object)DEFAULT_BATCH_DOWNLOAD_DIR, (Object[])new String[0]);
    }

    public static void maxContentLength(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("maxContentLength"), "Maximum length (in bytes) of extracted text that could be indexed (-1 means no limit and value should be less or equal than 2G). Human readable suffix K/M/G for KB/MB/GB (Default -1)").withRequiredArg().withValuesConvertedBy(RegexMatcher.regex((String)"[0-9]+[KMG]?"));
    }

    public static void sessionStoreType(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList("sessionStoreType"), "Type of session store").withRequiredArg().ofType(QueueType.class).defaultsTo((Object)QueueType.MEMORY, (Object[])new QueueType[0]);
    }

    public static void digestMethod(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(DIGEST_ALGORITHM_OPT)).withRequiredArg().ofType(DigestAlgorithm.class).defaultsTo((Object)DigestAlgorithm.SHA_384, (Object[])new DigestAlgorithm[0]).withValuesConvertedBy((ValueConverter)new DigestAlgorithm.DigestAlgorithmConverter());
    }

    public static void digestProjectName(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(DIGEST_PROJECT_NAME), "Includes the project name in the hash of documents when indexing. It is set by default to the defaultProject value. See noDigestProject option to disable it.").withRequiredArg().ofType(String.class);
    }

    public static void noDigestProject(OptionParser parser) {
        parser.acceptsAll(Collections.singletonList(NO_DIGEST_PROJECT), "Disable the project name in document hash processing (only using binary contents).").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
    }

    public static OptionSpec<String> extOption(OptionParser parser) {
        return parser.acceptsAll(Collections.singletonList("ext"), "Run CLI extension").withRequiredArg().ofType(String.class);
    }
}

