/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.reflect;

import java.util.Locale;
import java.util.Optional;
import org.icij.datashare.function.Functions;
import org.icij.datashare.function.ThrowingFunctions;

public interface EnumTypeToken {
    public String getClassName();

    default public String buildClassName(Class<?> interfaceClass, Enum<? extends EnumTypeToken> enumValue) {
        String packageName = interfaceClass.getPackage().getName();
        String typeName = enumValue.name().toLowerCase();
        String interfaceName = interfaceClass.getSimpleName();
        String implClassName = Functions.capitalize.apply(typeName) + interfaceName;
        return String.join((CharSequence)".", packageName, typeName, implClassName);
    }

    public static <E extends Enum<E>> Optional<E> parseClassName(Class<?> interfaceClass, Class<E> enumType, String className) {
        if (className == null || className.isEmpty()) {
            return Optional.empty();
        }
        String[] classNameSplit = className.split("\\.");
        String simpleClassName = classNameSplit[classNameSplit.length - 1];
        String interfaceName = interfaceClass.getSimpleName();
        String enumValueName = ThrowingFunctions.removePattFrom.apply(interfaceName).apply(simpleClassName);
        return EnumTypeToken.parse(enumType, enumValueName);
    }

    public static <E extends Enum<E>> Optional<E> parse(Class<E> enumType, String enumValueName) {
        if (enumValueName == null || enumValueName.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Enum.valueOf(enumType, enumValueName.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }
}

