/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.icij.datashare.batch.BatchSearchRecord;
import org.icij.datashare.text.Project;
import org.icij.datashare.time.DatashareTime;
import org.icij.datashare.user.User;

public class BatchSearch
extends BatchSearchRecord {
    public final LinkedHashMap<String, Integer> queries;
    public final List<String> fileTypes;
    public final List<String> tags;
    public final List<String> paths;
    public final int fuzziness;
    public final boolean phraseMatches;

    public BatchSearch(List<Project> projects, String name, String description, User user) {
        this(UUID.randomUUID().toString(), projects, name, description, new LinkedHashMap<String, Integer>(), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, false, null, null, null, 0, false, null, null);
    }

    public BatchSearch(List<Project> projects, String name, String description, LinkedHashSet<String> queries, User user) {
        this(UUID.randomUUID().toString(), projects, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, false, null, null, null, 0, false, null, null);
    }

    public BatchSearch(List<Project> projects, String name, String description, LinkedHashSet<String> queries, User user, boolean published) {
        this(UUID.randomUUID().toString(), projects, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, published, null, null, null, 0, false, null, null);
    }

    public BatchSearch(List<Project> projects, String name, String description, LinkedHashSet<String> queries, User user, boolean published, List<String> fileTypes, List<String> tags, List<String> paths, int fuzziness) {
        this(UUID.randomUUID().toString(), projects, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, published, fileTypes, tags, paths, fuzziness, false, null, null);
    }

    public BatchSearch(List<Project> projects, String name, String description, LinkedHashSet<String> queries, User user, boolean published, List<String> fileTypes, List<String> tags, List<String> paths, int fuzziness, boolean phraseMatches) {
        this(UUID.randomUUID().toString(), projects, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, published, fileTypes, tags, paths, fuzziness, phraseMatches, null, null);
    }

    public BatchSearch(List<Project> projects, String name, String description, LinkedHashSet<String> queries, User user, boolean published, List<String> fileTypes, List<String> tags, List<String> paths, boolean phraseMatches) {
        this(UUID.randomUUID().toString(), projects, name, description, BatchSearch.toLinkedHashMap(queries), DatashareTime.getInstance().now(), BatchSearchRecord.State.QUEUED, user, 0, published, fileTypes, tags, paths, 0, phraseMatches, null, null);
    }

    public BatchSearch(BatchSearch toCopy) {
        this(toCopy, new HashMap<String, String>());
    }

    public BatchSearch(BatchSearch toCopy, Map<String, String> overriddenParameters) {
        this(UUID.randomUUID().toString(), (List<Project>)toCopy.projects, Optional.ofNullable(overriddenParameters.get("name")).orElse(toCopy.name), Optional.ofNullable(overriddenParameters.get("description")).orElse(toCopy.description), toCopy.queries, DatashareTime.getNow(), BatchSearchRecord.State.QUEUED, toCopy.user, 0, toCopy.published, toCopy.fileTypes, toCopy.tags, toCopy.paths, toCopy.fuzziness, toCopy.phraseMatches, null, null);
    }

    public BatchSearch(String uuid, List<Project> projects, String name, String description, LinkedHashSet<String> queries, Date date, BatchSearchRecord.State state, User user) {
        this(uuid, projects, name, description, BatchSearch.toLinkedHashMap(queries), date, state, user, 0, false, null, null, null, 0, false, null, null);
    }

    public BatchSearch(List<Project> projects, String name, String description, LinkedHashSet<String> queries, Date date, BatchSearchRecord.State state, boolean published) {
        this(UUID.randomUUID().toString(), projects, name, description, BatchSearch.toLinkedHashMap(queries), date, state, User.local(), 0, published, null, null, null, 0, false, null, null);
    }

    public BatchSearch(List<Project> projects, String name, String description, LinkedHashSet<String> queries, Date date) {
        this(projects, name, description, queries, date, BatchSearchRecord.State.QUEUED, false);
    }

    public BatchSearch(String uuid, List<Project> projects, String name, String description, LinkedHashMap<String, Integer> queries, Date date, BatchSearchRecord.State state, User user, int nbResults, boolean published, List<String> fileTypes, List<String> tags, List<String> paths, int fuzziness, boolean phraseMatches, String errorMessage, String errorQuery) {
        super(uuid, projects, name, description, queries.size(), date, state, user, nbResults, published, errorMessage, errorQuery);
        if (this.getNbQueries() == 0) {
            throw new IllegalArgumentException("queries cannot be empty");
        }
        this.queries = queries;
        this.fileTypes = Collections.unmodifiableList(Optional.ofNullable(fileTypes).orElse(new ArrayList()));
        this.tags = Collections.unmodifiableList(Optional.ofNullable(tags).orElse(new ArrayList()));
        this.paths = Collections.unmodifiableList(Optional.ofNullable(paths).orElse(new ArrayList()));
        this.fuzziness = fuzziness;
        this.phraseMatches = phraseMatches;
    }

    public BatchSearch(String uuid, List<Project> projects, String name, String description, Integer nbQueries, Date date, BatchSearchRecord.State state, User user, int nbResults, boolean published, List<String> fileTypes, List<String> tags, List<String> paths, int fuzziness, boolean phraseMatches, String errorMessage, String errorQuery) {
        super(uuid, projects, name, description, nbQueries, date, state, user, nbResults, published, errorMessage, errorQuery);
        this.queries = new LinkedHashMap();
        this.fileTypes = Collections.unmodifiableList(Optional.ofNullable(fileTypes).orElse(new ArrayList()));
        this.tags = Collections.unmodifiableList(Optional.ofNullable(tags).orElse(new ArrayList()));
        this.paths = Collections.unmodifiableList(Optional.ofNullable(paths).orElse(new ArrayList()));
        this.fuzziness = fuzziness;
        this.phraseMatches = phraseMatches;
    }

    @JsonIgnore
    public List<String> getQueryList() {
        return new ArrayList<String>(this.queries.keySet());
    }

    private static LinkedHashMap<String, Integer> toLinkedHashMap(LinkedHashSet<String> queries) {
        return Optional.ofNullable(queries).orElseThrow(() -> new IllegalArgumentException("queries cannot be null")).stream().collect(Collectors.toMap(Function.identity(), i -> 0, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    @Override
    public String toString() {
        return "BatchSearch{" + this.uuid + " name='" + this.name + "' (" + this.state + ")}";
    }
}

