/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.icij.datashare.json.JsonObjectMapper;
import org.icij.datashare.text.Project;
import org.icij.datashare.time.DatashareTime;
import org.icij.datashare.user.User;

public class BatchDownload {
    public static final String ZIP_FORMAT = "archive_%s_%s.zip";
    public final String uuid;
    public final List<Project> projects;
    public final Path filename;
    public final String query;
    public final String uri;
    public final User user;
    public final boolean encrypted;
    public volatile long zipSize;
    @JsonIgnore
    private final JsonNode jsonNode;

    public BatchDownload(List<Project> projects, User user, String query, String uri) {
        this(projects, user, query, uri, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), false);
    }

    public BatchDownload(List<Project> projects, User user, String query) {
        this(projects, user, query, null, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), false);
    }

    public BatchDownload(List<Project> projects, User user, String query, String uri, Path downloadDir, boolean isEncrypted) {
        this(UUID.randomUUID().toString(), projects, downloadDir.resolve(BatchDownload.createFilename(user)), query, uri, user, isEncrypted, 0L);
    }

    public BatchDownload(List<Project> projects, User user, String query, Path downloadDir, boolean isEncrypted) {
        this(UUID.randomUUID().toString(), projects, downloadDir.resolve(BatchDownload.createFilename(user)), query, null, user, isEncrypted, 0L);
    }

    @JsonCreator
    private BatchDownload(@JsonProperty(value="uuid") String uuid, @JsonProperty(value="projects") List<Project> projects, @JsonProperty(value="filename") Path filename, @JsonProperty(value="query") String query, @JsonProperty(value="uri") String uri, @JsonProperty(value="user") User user, @JsonProperty(value="encrypted") boolean encrypted, @JsonProperty(value="zipSize") long zipSize) {
        this.uuid = uuid;
        this.projects = Collections.unmodifiableList(Optional.ofNullable(projects).orElse(new ArrayList()));
        this.user = user;
        this.query = Optional.ofNullable(query).orElseThrow(() -> new IllegalArgumentException("query cannot be null or empty"));
        this.uri = uri;
        this.filename = filename;
        this.encrypted = encrypted;
        this.zipSize = zipSize;
        if (this.isJsonQuery()) {
            try {
                this.jsonNode = JsonObjectMapper.MAPPER.readTree(query.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.jsonNode = null;
        }
    }

    public static Path createFilename(User user) {
        User nonNullUser = Optional.ofNullable(user).orElseThrow(() -> new IllegalArgumentException("user cannot be null or empty"));
        String strTime = DateTimeFormatter.ISO_DATE_TIME.format(ZonedDateTime.from(DatashareTime.getInstance().now().toInstant().atZone(ZoneId.of("GMT")))).replace(":", "_");
        return Paths.get(String.format(ZIP_FORMAT, nonNullUser.getId(), strTime), new String[0]);
    }

    public static BatchDownload nullObject() {
        return new BatchDownload(null, null, Paths.get("/dev/null", new String[0]), "", null, User.nullUser(), false, 0L);
    }

    public void setZipSize(long zipSize) {
        this.zipSize = zipSize;
    }

    public boolean getExists() {
        return Files.exists(this.filename, new LinkOption[0]);
    }

    @JsonIgnore
    public boolean isJsonQuery() {
        return this.query.trim().startsWith("{") && this.query.trim().endsWith("}");
    }

    public JsonNode queryAsJson() {
        return Optional.ofNullable(this.jsonNode).orElseThrow(() -> new IllegalStateException("cannot get JSON node from query string"));
    }

    public String toString() {
        return "BatchDownload{filename=" + this.filename + "}";
    }

    public int hashCode() {
        return Objects.hash(this.filename, this.query);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchDownload that = (BatchDownload)o;
        return Objects.equals(this.filename, that.filename) && Objects.equals(this.query, that.query);
    }
}

