/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare;

import java.net.URI;
import java.util.Date;
import java.util.Objects;
import org.icij.datashare.time.DatashareTime;
import org.icij.datashare.user.User;

public class UserEvent {
    public final int id;
    public final User user;
    public final Date creationDate;
    public final Date modificationDate;
    public final Type type;
    public final String name;
    public final URI uri;

    public UserEvent(int id, User user, Type type, String name, URI uri, Date creationDate, Date modificationDate) {
        this.id = id;
        this.user = user;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
        this.type = type;
        this.name = name;
        this.uri = uri;
    }

    public UserEvent(User user, Type type, String name, URI uri, Date creationDate, Date modificationDate) {
        this(0, user, type, name, uri, creationDate, modificationDate);
    }

    public UserEvent(User user, Type type, String name, URI uri) {
        this(user, type, name, uri, DatashareTime.getInstance().now(), DatashareTime.getInstance().now());
    }

    public String toString() {
        return "Name : " + this.name + " Uri : " + this.uri + " Creation Date : " + this.creationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserEvent userEvent = (UserEvent)o;
        return this.user.equals(userEvent.user) && this.uri.equals(userEvent.uri) && this.creationDate.equals(userEvent.creationDate);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.uri, this.creationDate);
    }

    public static enum Type {
        DOCUMENT(0),
        SEARCH(1);

        public final short id;

        private Type(short id) {
            this.id = id;
        }

        public static Type fromId(int id) {
            for (Type t : Type.values()) {
                if (t.id != id) continue;
                return t;
            }
            throw new IllegalArgumentException("cannot find id " + id);
        }
    }
}

