/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HumanReadableSize {
    static Pattern pattern = Pattern.compile("([0-9]+)([KMG])");

    public static long parse(String humanReadableSize) {
        Matcher match = pattern.matcher(humanReadableSize);
        if (match.matches()) {
            long value = Long.parseLong(match.group(1));
            Unit unit = Unit.valueOf(match.group(2));
            return value * unit.bytes;
        }
        return Long.parseLong(humanReadableSize);
    }

    public static enum Unit {
        K(1024L),
        M(Unit.K.bytes * 1024L),
        G(Unit.M.bytes * 1024L);

        private final long bytes;

        private Unit(long bytes) {
            this.bytes = bytes;
        }
    }
}

