/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.icij.datashare.Entity;
import org.icij.datashare.text.CharsetDeserializer;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.PathDeserializer;
import org.icij.datashare.text.PathSerializer;
import org.icij.datashare.text.Project;
import org.icij.datashare.text.Tag;
import org.icij.datashare.text.indexing.IndexParent;
import org.icij.datashare.text.indexing.IndexRoot;
import org.icij.datashare.text.indexing.IndexType;
import org.icij.datashare.text.nlp.Pipeline;

@IndexType(value="Document")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Document
implements Entity {
    private static final long serialVersionUID = 5913568429773112L;
    @JsonIgnore
    private final Project project;
    private final String id;
    @JsonSerialize(using=PathSerializer.class)
    @JsonDeserialize(using=PathDeserializer.class)
    private final Path path;
    @JsonSerialize(using=PathSerializer.class)
    @JsonDeserialize(using=PathDeserializer.class)
    private final Path dirname;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private final Date extractionDate;
    private final short extractionLevel;
    private final String content;
    private final List<Map<String, String>> content_translated;
    private final long contentLength;
    private final String contentType;
    @JsonDeserialize(using=CharsetDeserializer.class)
    private final Charset contentEncoding;
    private final Language language;
    private final Map<String, Object> metadata;
    private final Status status;
    private final Set<Pipeline.Type> nerTags;
    private final Set<Tag> tags;
    @IndexParent
    private final String parentDocument;
    @IndexRoot
    private final String rootDocument;

    Document(Project project, String id, Path filePath, String content, Language language, Charset charset, String mimetype, Map<String, Object> metadata, Status status, Set<Pipeline.Type> nerTags, Date extractionDate, String parentDocument, String rootDocument, Short extractionLevel, Long contentLength) {
        this(project, id, filePath, content, null, language, extractionDate, charset, mimetype, extractionLevel.shortValue(), metadata, status, nerTags, parentDocument, rootDocument, contentLength, new HashSet<Tag>());
    }

    Document(Project project, String id, Path filePath, String content, List<Map<String, String>> content_translated, Language language, Charset charset, String mimetype, Map<String, Object> metadata, Status status, Set<Pipeline.Type> nerTags, Date extractionDate, String parentDocument, String rootDocument, Short extractionLevel, Long contentLength, Set<Tag> tags) {
        this(project, id, filePath, content, content_translated, language, extractionDate, charset, mimetype, extractionLevel.shortValue(), metadata, status, nerTags, parentDocument, rootDocument, contentLength, tags);
    }

    @JsonCreator
    private Document(@JsonProperty(value="projectId") Project project, @JsonProperty(value="id") String id, @JsonProperty(value="path") Path path, @JsonProperty(value="content") String content, @JsonProperty(value="content_translated") List<Map<String, String>> content_translated, @JsonProperty(value="language") Language language, @JsonProperty(value="extractionDate") Date extractionDate, @JsonProperty(value="contentEncoding") Charset contentEncoding, @JsonProperty(value="contentType") String contentType, @JsonProperty(value="extractionLevel") int extractionLevel, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="status") Status status, @JsonProperty(value="nerTags") Set<Pipeline.Type> nerTags, @JsonProperty(value="parentDocument") String parentDocument, @JsonProperty(value="rootDocument") String rootDocument, @JsonProperty(value="contentLength") Long contentLength, @JsonProperty(value="tags") Set<Tag> tags) {
        this.id = id;
        this.project = project;
        this.path = path;
        this.dirname = path == null ? null : Document.getDirnameFrom(path);
        this.content = Optional.ofNullable(content).orElse("");
        this.content_translated = Optional.ofNullable(content_translated).orElse(new ArrayList());
        this.extractionDate = extractionDate;
        this.extractionLevel = (short)extractionLevel;
        this.contentLength = Optional.ofNullable(contentLength).orElse(0L);
        this.language = language;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.metadata = metadata;
        this.status = status;
        this.nerTags = nerTags;
        this.parentDocument = parentDocument;
        this.rootDocument = rootDocument;
        this.tags = tags;
    }

    static String getHash(Project project, Path path) {
        return HASHER.hash(path, project.getId());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public Project getProject() {
        return this.project;
    }

    public String getProjectId() {
        return this.project.getId();
    }

    public String getContent() {
        return this.content;
    }

    @JsonGetter(value="content_translated")
    public List<Map<String, String>> getContentTranslated() {
        return this.content_translated;
    }

    public int getContentTextLength() {
        return this.content.length();
    }

    public Path getPath() {
        return this.path;
    }

    public Path getDirname() {
        return this.dirname;
    }

    public Date getExtractionDate() {
        return this.extractionDate;
    }

    public Charset getContentEncoding() {
        return this.contentEncoding;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Language getLanguage() {
        return this.language;
    }

    public short getExtractionLevel() {
        return this.extractionLevel;
    }

    public String getRootDocument() {
        return Optional.ofNullable(this.rootDocument).orElse(this.getId());
    }

    public boolean isRootDocument() {
        return this.getRootDocument().equals(this.getId());
    }

    public String getParentDocument() {
        return this.parentDocument;
    }

    public Status getStatus() {
        return this.status;
    }

    public Set<Pipeline.Type> getNerTags() {
        return this.nerTags;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public Date getCreationDate() {
        String creationDate = (String)((Map)Optional.ofNullable(this.metadata).orElse(new HashMap())).get("tika_metadata_dcterms_created");
        if (creationDate == null) {
            return null;
        }
        Instant instant = null;
        try {
            instant = ZonedDateTime.parse(creationDate).toInstant();
        }
        catch (DateTimeParseException e) {
            LOGGER.debug("exception when parsing creation date (" + e + ") trying with local date time");
        }
        try {
            instant = LocalDateTime.parse(creationDate).toInstant(OffsetDateTime.now().getOffset());
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return instant == null ? null : Date.from(instant);
    }

    @JsonIgnore
    public short getNerMask() {
        return Document.nerMask(this.getNerTags());
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public String getName() {
        return this.path.getName(this.path.getNameCount() - 1).toString();
    }

    public String toString() {
        return (this.path != null ? this.getName() : "") + "(" + this.getId() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.id, document.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    private static Path getDirnameFrom(Path filePath) {
        return Optional.ofNullable(filePath.getParent()).orElse(Paths.get("", new String[0]));
    }

    static short nerMask(Set<Pipeline.Type> typeSet) {
        return typeSet.stream().map(t -> t.mask).reduce(Integer::sum).orElse(0).shortValue();
    }

    public static Set<Pipeline.Type> fromNerMask(int mask) {
        return mask == 0 ? new HashSet<Pipeline.Type>() : Arrays.stream(Pipeline.Type.values()).filter(t -> (mask & t.mask) == t.mask).collect(Collectors.toSet());
    }

    public static enum Status {
        PARSED(0),
        INDEXED(1),
        DONE(2);

        public final short code;

        private Status(short code) {
            this.code = code;
        }

        public static Status fromCode(int code) {
            for (Status status : Status.values()) {
                if (status.code != code) continue;
                return status;
            }
            throw new IllegalArgumentException("invalid status code " + code);
        }
    }
}

