/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.icij.datashare.text.Hasher;

public class AwsEtag {
    private static final int BOTO3_CHUNK_SIZE = 0x800000;
    private static final Pattern MD5_PATTERN = Pattern.compile("[a-f0-9]{32}");
    private static final Pattern FULL_ETAG_PATTERN = Pattern.compile("(" + MD5_PATTERN.pattern() + ")(?:-([0-9]+))?");
    private final String md5;
    private final int nbParts;

    AwsEtag(String md5, int nbParts) {
        this.md5 = md5;
        this.nbParts = nbParts;
    }

    public static AwsEtag parse(String etagString) {
        Matcher matcher = FULL_ETAG_PATTERN.matcher(etagString);
        if (matcher.matches()) {
            String md5 = matcher.group(1);
            String nbParts = matcher.group(2);
            return new AwsEtag(md5, nbParts == null ? 1 : Integer.parseInt(nbParts));
        }
        throw new IllegalArgumentException("Invalid format for Etag : <" + etagString + ">");
    }

    public static AwsEtag compute(File file) {
        return AwsEtag.compute(file, 0x800000);
    }

    public static AwsEtag compute(File file, int chunkSize) {
        int nbChunks = (int)Math.ceil((double)file.length() / (double)chunkSize);
        byte[] buffer = new byte[chunkSize];
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream resultOutputStream = new ByteArrayOutputStream();
            for (int chunkIndex = 0; chunkIndex < nbChunks; ++chunkIndex) {
                int nbBytesRead = bufferedInputStream.read(buffer);
                if (nbBytesRead == buffer.length) {
                    resultOutputStream.write(Hasher.MD5.hash(buffer));
                    continue;
                }
                resultOutputStream.write(Hasher.MD5.hash(Arrays.copyOf(buffer, nbBytesRead)));
            }
            return nbChunks == 1 ? new AwsEtag(Hasher.getHex(resultOutputStream.toByteArray()), 1) : new AwsEtag(Hasher.getHex(Hasher.MD5.hash(resultOutputStream.toByteArray())), nbChunks);
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsEtag awsEtag = (AwsEtag)o;
        return this.nbParts == awsEtag.nbParts && Objects.equals(this.md5, awsEtag.md5);
    }

    public int hashCode() {
        return Objects.hash(this.md5, this.nbParts);
    }

    public String toString() {
        return this.nbParts == 1 ? this.md5 : this.md5 + "-" + this.nbParts;
    }
}

