/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.parser;

import com.icesoft.faces.webapp.parser.UnknownJSFImplementationException;
import java.util.List;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImplementationUtil {
    protected static Log log = LogFactory.getLog((Class)ImplementationUtil.class);
    private static boolean isRI = false;
    private static boolean isMyFaces = false;
    private static boolean isJSF12 = false;
    private static boolean isJSF2 = false;
    private static boolean jsfStateSaving;
    private static boolean isStockAttributeTracking;
    private static boolean isAnyAttributeTracking;
    private static String RI_MARKER;
    private static String MYFACES_MARKER;
    private static String JSF12_MARKER;
    private static String JSF2_MARKER;
    private static String RI_COMPONENT_STACK_KEY;
    private static String MYFACES_COMPONENT_STACK_KEY;

    private static boolean isAttributeTracking(HtmlOutputText comp) {
        boolean tracked = false;
        comp.setTitle("value");
        comp.getAttributes().put("lang", "value");
        comp.getAttributes().put("no_method", "value");
        List attributesThatAreSet = (List)comp.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (attributesThatAreSet != null && attributesThatAreSet.contains("title") && attributesThatAreSet.contains("lang") && attributesThatAreSet.contains("no_method")) {
            tracked = true;
        }
        return tracked;
    }

    public static boolean isRI() {
        return isRI;
    }

    public static boolean isMyFaces() {
        return isMyFaces;
    }

    public static boolean isJSF12() {
        return isJSF12;
    }

    public static boolean isJSF2() {
        return isJSF2;
    }

    public static boolean isStockAttributeTracking() {
        return isStockAttributeTracking;
    }

    public static boolean isAnyAttributeTracking() {
        return isAnyAttributeTracking;
    }

    public static String getComponentStackKey() {
        String key = null;
        if (isRI) {
            key = RI_COMPONENT_STACK_KEY;
        } else if (isMyFaces) {
            key = MYFACES_COMPONENT_STACK_KEY;
        }
        if (key != null) {
            return key;
        }
        if (log.isFatalEnabled()) {
            log.fatal((Object)"cannot detect JSF implementation so cannot determine component stack key");
        }
        throw new UnknownJSFImplementationException("cannot determine component stack key");
    }

    public static List getComponentStack(PageContext pageContext) {
        List list = (List)pageContext.getAttribute(ImplementationUtil.getComponentStackKey(), 2);
        if (null == list) {
            list = (List)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(ImplementationUtil.getComponentStackKey());
        }
        return list;
    }

    public static void setJSFStateSaving(boolean isJSFStateSaved) {
        jsfStateSaving = isJSFStateSaved;
    }

    public static boolean isJSFStateSaving() {
        return jsfStateSaving;
    }

    static {
        isStockAttributeTracking = false;
        isAnyAttributeTracking = false;
        RI_MARKER = "com.sun.faces.application.ApplicationImpl";
        MYFACES_MARKER = "org.apache.myfaces.application.ApplicationImpl";
        JSF12_MARKER = "javax.faces.webapp.UIComponentELTag";
        JSF2_MARKER = "javax.faces.context.PartialViewContext";
        RI_COMPONENT_STACK_KEY = "javax.faces.webapp.COMPONENT_TAG_STACK";
        MYFACES_COMPONENT_STACK_KEY = "javax.faces.webapp.UIComponentTag.COMPONENT_STACK";
        try {
            Class.forName(RI_MARKER);
            isRI = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            Class.forName(MYFACES_MARKER);
            isMyFaces = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("JSF-RI: " + isRI + "  MyFaces: " + isMyFaces));
        }
        try {
            Class.forName(JSF12_MARKER);
            isJSF12 = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("JSF-12: " + isJSF12));
        }
        try {
            Class.forName(JSF2_MARKER);
            isJSF2 = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("JSF-2: " + isJSF2));
        }
        try {
            HtmlOutputText comp = new HtmlOutputText();
            isStockAttributeTracking = ImplementationUtil.isAttributeTracking(comp);
            comp = (HtmlOutputText)Class.forName("com.icesoft.faces.component.ext.HtmlOutputText").newInstance();
            isAnyAttributeTracking = ImplementationUtil.isAttributeTracking(comp);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

