/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class SecretRenderer
extends DomBasicInputRenderer {
    private static final String[] passThruAttributes = new String[]{"accesskey", "alt", "dir", "lang", "maxlength", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onselect", "size", "style", "tabindex", "title"};

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIInput.class);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIInput.class);
    }

    protected void renderEnd(FacesContext facesContext, UIComponent uiComponent, String currentValue) throws IOException {
        Element root;
        this.validateParameters(facesContext, uiComponent, UIInput.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            root = domContext.createElement("input");
            domContext.setRootNode(root);
            SecretRenderer.setRootElementId(facesContext, root, uiComponent);
            root.setAttribute("type", "password");
            root.setAttribute("name", uiComponent.getClientId(facesContext));
        }
        root = (Element)domContext.getRootNode();
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, passThruAttributes);
        String[] attributes = new String[]{"disabled", "readonly"};
        for (int i = 0; i < attributes.length; ++i) {
            Object attribute = uiComponent.getAttributes().get(attributes[i]);
            if (!(attribute instanceof Boolean) || !((Boolean)attribute).booleanValue()) continue;
            root.setAttribute(attributes[i], attributes[i]);
        }
        String autoComplete = (String)uiComponent.getAttributes().get("autocomplete");
        if (autoComplete != null && "off".equalsIgnoreCase(autoComplete)) {
            root.setAttribute("autocomplete", "off");
        }
        if (this.redisplayAttributeIsTrue(uiComponent) && currentValue != null) {
            root.setAttribute("value", currentValue);
        } else {
            root.setAttribute("value", "");
        }
        String mousedownScript = (String)uiComponent.getAttributes().get("onmousedown");
        root.setAttribute("onmousedown", SecretRenderer.combinedPassThru(mousedownScript, "this.focus();"));
    }

    private boolean redisplayAttributeIsTrue(UIComponent uiComponent) {
        Object redisplayAttribute = uiComponent.getAttributes().get("redisplay");
        return redisplayAttribute != null && redisplayAttribute.toString().toLowerCase().equals("true");
    }
}

