/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.template.groupware;

import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.extensions.property.Repeats;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTimePropertyModifiers;
import net.fortuna.ical4j.model.DescriptivePropertyModifiers;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.RecurrencePropertyModifiers;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.immutable.ImmutableTransp;
import org.ical4j.template.AbstractTemplate;

public class Observance
extends AbstractTemplate<VEvent> {
    private String title;
    private Temporal start;
    private Temporal end;
    private List<LocalDate> dates = new ArrayList<LocalDate>();
    private Repeats<LocalDate> schedule;

    public Observance() {
        super(VEvent.class);
    }

    public Observance(Class<? extends VEvent> typeClass) {
        super(typeClass);
    }

    public <T extends VEvent> Observance(T prototype) {
        super(prototype.getClass());
        this.setPrototype(prototype);
    }

    public Observance title(String title) {
        this.title = title;
        return this;
    }

    public Observance start(Temporal date) {
        this.start = date;
        return this;
    }

    public Observance end(Temporal date) {
        this.end = date;
        return this;
    }

    public Observance date(LocalDate date) {
        this.dates.add(date);
        return this;
    }

    public Observance repeats(Repeats<LocalDate> schedule) {
        this.schedule = schedule;
        return this;
    }

    @Override
    public VEvent apply(VEvent vEvent) {
        vEvent.replace((Property)ImmutableTransp.TRANSPARENT);
        vEvent.with(DescriptivePropertyModifiers.SUMMARY, (Object)this.title);
        vEvent.with(DateTimePropertyModifiers.DTSTART, (Object)this.start);
        vEvent.with(DateTimePropertyModifiers.DTEND, (Object)this.end);
        vEvent.with(RecurrencePropertyModifiers.RRULE, this.schedule);
        vEvent.with(RecurrencePropertyModifiers.RDATE, (Object)new DateList(this.dates));
        return vEvent;
    }
}

