/*
 * Decompiled with CFR 0.152.
 */
package org.ical4j.template.groupware;

import java.net.URI;
import java.time.temporal.Temporal;
import net.fortuna.ical4j.extensions.concept.ActionType;
import net.fortuna.ical4j.extensions.link.Next;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.DescriptivePropertyModifiers;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.RelationshipPropertyModifiers;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Uid;
import org.ical4j.template.AbstractTemplate;

public class Agenda
extends AbstractTemplate<VToDo> {
    private Temporal start;
    private Temporal due;
    private URI organizer;
    private Uid uid;
    private String summary;
    private String description;
    private Next nextItem;

    public Agenda() {
        super(VToDo.class);
    }

    public Agenda(Class<? extends VToDo> typeClass) {
        super(typeClass);
    }

    public <T extends VToDo> Agenda(T prototype) {
        super(prototype.getClass());
        this.setPrototype(prototype);
    }

    public Agenda uid(Uid uid) {
        this.uid = uid;
        return this;
    }

    public Agenda summary(String summary) {
        this.summary = summary;
        return this;
    }

    public Agenda nextItem(VToDo item) {
        this.nextItem = new Next((Component)item);
        return this;
    }

    @Override
    public VToDo apply(VToDo vToDo) {
        vToDo.replace((Property)ActionType.AGENDA);
        vToDo.with(DescriptivePropertyModifiers.SUMMARY, (Object)this.summary);
        vToDo.with(DescriptivePropertyModifiers.DESCRIPTION, (Object)this.description);
        vToDo.with(RelationshipPropertyModifiers.ORGANIZER_URI, (Object)this.organizer);
        vToDo.with(RelationshipPropertyModifiers.UID, (Object)this.uid);
        vToDo.with(RelationshipPropertyModifiers.LINK, (Object)this.nextItem);
        return vToDo;
    }
}

