/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.openid;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.vcard.Entity;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.property.Address;
import net.fortuna.ical4j.vcard.property.Email;
import net.fortuna.ical4j.vcard.property.Name;
import net.fortuna.ical4j.vcard.property.Photo;
import org.mnode.ical4j.serializer.JsonMapper;

public class JwtClaimsMapper
extends StdDeserializer<Entity>
implements JsonMapper {
    public JwtClaimsMapper(Class<?> vc) {
        super(vc);
    }

    public Entity deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Entity entity = new Entity();
        this.assertNextToken(p, JsonToken.FIELD_NAME);
        while (p.getCurrentToken() != JsonToken.END_OBJECT) {
            try {
                entity.add(this.parseProperty(p));
            }
            catch (URISyntaxException | ParseException e) {
                throw new IllegalArgumentException(e);
            }
            p.nextToken();
        }
        return entity;
    }

    private Property parseProperty(JsonParser p) throws IOException, URISyntaxException, ParseException {
        String propertyName = p.currentName();
        this.assertNextToken(p, JsonToken.VALUE_STRING);
        switch (propertyName) {
            case "name": {
                return new Name(p.getValueAsString());
            }
            case "picture": {
                return new Photo(URI.create(p.getValueAsString()));
            }
            case "email": {
                return new Email(p.getValueAsString());
            }
            case "address": {
                return this.parseAddress((JsonNode)p.getCurrentValue());
            }
        }
        return null;
    }

    private Address parseAddress(JsonNode n) {
        String formatted = n.get("formatted").asText();
        String street = n.get("street_address").asText();
        String locality = n.get("locality").asText();
        String region = n.get("region").asText();
        String postal_code = n.get("postal_code").asText();
        String country = n.get("country").asText();
        return new Address(null, null, street, locality, region, postal_code, country, new Type[0]);
    }
}

