/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.vcard.Entity;
import net.fortuna.ical4j.vcard.VCardParameterFactorySupplier;
import net.fortuna.ical4j.vcard.VCardPropertyFactorySupplier;
import net.fortuna.ical4j.vcard.parameter.Value;
import org.mnode.ical4j.serializer.JsonMapper;
import org.mnode.ical4j.serializer.ParameterMapper;
import org.mnode.ical4j.serializer.ParameterMapperImpl;
import org.mnode.ical4j.serializer.PropertyMapper;

public class JCardMapper
extends StdDeserializer<Entity>
implements JsonMapper {
    private final PropertyMapper propertyMapper = new PropertyMapperImpl(new VCardPropertyFactorySupplier().get());
    private final ParameterMapper parameterMapper = new ParameterMapperImpl(new VCardParameterFactorySupplier().get());

    public JCardMapper(Class<?> vc) {
        super(vc);
    }

    public Entity deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Entity entity = new Entity();
        this.assertTextValue(p, "vcard");
        this.assertNextToken(p, JsonToken.START_ARRAY);
        while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
            entity.add(this.propertyMapper.map(p));
        }
        return entity;
    }

    class PropertyMapperImpl
    implements PropertyMapper {
        private final List<PropertyFactory<?>> propertyFactories;

        public PropertyMapperImpl(List<PropertyFactory<?>> propertyFactories) {
            this.propertyFactories = propertyFactories;
        }

        @Override
        public Property map(JsonParser p) throws IOException {
            String propertyType;
            JCardMapper.this.assertCurrentToken(p, JsonToken.START_ARRAY);
            PropertyBuilder builder = new PropertyBuilder(this.propertyFactories);
            builder.name(p.nextTextValue());
            JCardMapper.this.assertNextToken(p, JsonToken.START_OBJECT);
            ArrayList params = new ArrayList();
            while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
                builder.parameter(JCardMapper.this.parameterMapper.map(p));
            }
            switch (propertyType = p.nextTextValue()) {
                case "binary": {
                    builder.parameter((Parameter)Value.BINARY);
                }
                case "duration": {
                    builder.parameter((Parameter)Value.DURATION);
                }
                case "date": {
                    builder.parameter((Parameter)Value.DATE);
                }
                case "date-time": {
                    builder.parameter((Parameter)Value.DATE_TIME);
                }
                case "uri": {
                    builder.parameter((Parameter)Value.URI);
                }
            }
            builder.value(p.nextTextValue());
            JCardMapper.this.assertNextToken(p, JsonToken.END_ARRAY);
            return builder.build();
        }
    }
}

