/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jotn;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VToDo;
import org.mnode.ical4j.serializer.JsonMapper;
import org.mnode.ical4j.serializer.jotn.ContentMapper;

public class ComponentListMapper
extends StdDeserializer<ComponentList<? extends Component>>
implements JsonMapper {
    private final ContentMapper<VEvent> vEventMapper = new ContentMapper<VEvent>(VEvent::new);
    private final ContentMapper<VToDo> vToDoMapper = new ContentMapper<VToDo>(VToDo::new);
    private final ContentMapper<VJournal> vJournalMapper = new ContentMapper<VJournal>(VJournal::new);
    private final ContentMapper<VAvailability> vAvailabilityMapper = new ContentMapper<VAvailability>(VAvailability::new);

    public ComponentListMapper() {
        this(null);
    }

    public ComponentListMapper(Class<?> vc) {
        super(vc);
    }

    public ComponentList<? extends Component> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        ArrayList<Component> components = new ArrayList<Component>();
        while (JsonToken.FIELD_NAME.equals((Object)p.nextToken())) {
            String componentType = p.currentName();
            this.assertNextToken(p, JsonToken.START_OBJECT);
            switch (componentType) {
                case "event": {
                    components.add((Component)this.vEventMapper.deserialize(p, ctxt));
                    break;
                }
                case "to-do": {
                    components.add((Component)this.vToDoMapper.deserialize(p, ctxt));
                    break;
                }
                case "journal": {
                    components.add((Component)this.vJournalMapper.deserialize(p, ctxt));
                    break;
                }
                case "availability": {
                    components.add((Component)this.vAvailabilityMapper.deserialize(p, ctxt));
                }
            }
        }
        return new ComponentList(components);
    }
}

