/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.List;
import net.fortuna.ical4j.data.DefaultParameterFactorySupplier;
import net.fortuna.ical4j.data.DefaultPropertyFactorySupplier;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.vcard.Entity;
import org.mnode.ical4j.serializer.JCalDecoder;
import org.mnode.ical4j.serializer.JsonMapper;
import org.mnode.ical4j.serializer.ParameterMapper;
import org.mnode.ical4j.serializer.ParameterMapperImpl;
import org.mnode.ical4j.serializer.PropertyMapper;

public class XCardMapper
extends StdDeserializer<Entity>
implements JsonMapper {
    private final PropertyMapper propertyMapper = new PropertyMapperImpl(new DefaultPropertyFactorySupplier().get());
    private final ParameterMapper parameterMapper = new ParameterMapperImpl(new DefaultParameterFactorySupplier().get());

    public XCardMapper(Class<?> vc) {
        super(vc);
    }

    public Entity deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Entity card = new Entity();
        this.assertNextName(p, "vcard");
        this.assertNextToken(p, JsonToken.START_OBJECT);
        while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
            card.add(this.propertyMapper.map(p));
        }
        return card;
    }

    class PropertyMapperImpl
    implements PropertyMapper {
        private final List<PropertyFactory<?>> propertyFactories;

        public PropertyMapperImpl(List<PropertyFactory<?>> propertyFactories) {
            this.propertyFactories = propertyFactories;
        }

        @Override
        public Property map(JsonParser p) throws IOException {
            String propertyType;
            PropertyBuilder builder = new PropertyBuilder(this.propertyFactories);
            builder.name(p.currentName());
            XCardMapper.this.assertNextToken(p, JsonToken.START_OBJECT);
            XCardMapper.this.assertNextName(p, "parameters");
            if (p.nextToken() != JsonToken.VALUE_STRING) {
                XCardMapper.this.assertCurrentToken(p, JsonToken.START_OBJECT);
                while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
                    try {
                        builder.parameter(XCardMapper.this.parameterMapper.map(p));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
            switch (propertyType = p.nextFieldName()) {
                case "date": {
                    builder.parameter((Parameter)Value.DATE);
                    builder.value(JCalDecoder.DATE.decode(p.nextTextValue()));
                    break;
                }
                case "date-time": {
                    builder.parameter((Parameter)Value.DATE_TIME);
                    builder.value(JCalDecoder.DATE_TIME.decode(p.nextTextValue()));
                    break;
                }
                case "time": {
                    builder.parameter((Parameter)Value.TIME);
                    builder.value(JCalDecoder.TIME.decode(p.nextTextValue()));
                    break;
                }
                case "utc-offset": {
                    builder.parameter((Parameter)Value.UTC_OFFSET);
                    builder.value(JCalDecoder.UTCOFFSET.decode(p.nextTextValue()));
                    break;
                }
                case "binary": {
                    builder.parameter((Parameter)Value.BINARY);
                }
                case "duration": {
                    builder.parameter((Parameter)Value.DURATION);
                }
                case "period": {
                    builder.parameter((Parameter)Value.PERIOD);
                }
                case "uri": {
                    builder.parameter((Parameter)Value.URI);
                }
                default: {
                    builder.value(p.nextTextValue());
                }
            }
            XCardMapper.this.assertNextToken(p, JsonToken.END_OBJECT);
            return builder.build();
        }
    }
}

