/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.data.DefaultParameterFactorySupplier;
import net.fortuna.ical4j.data.DefaultPropertyFactorySupplier;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentBuilder;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.component.Available;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.Value;
import org.mnode.ical4j.serializer.ComponentMapper;
import org.mnode.ical4j.serializer.JCalDecoder;
import org.mnode.ical4j.serializer.JsonMapper;
import org.mnode.ical4j.serializer.ParameterMapper;
import org.mnode.ical4j.serializer.ParameterMapperImpl;
import org.mnode.ical4j.serializer.PropertyMapper;

public class JCalMapper
extends JsonDeserializer<Calendar>
implements JsonMapper {
    private final ComponentMapper componentMapper = new ComponentMapperImpl(Arrays.asList(new Available.Factory(), new Daylight.Factory(), new Standard.Factory(), new VAlarm.Factory(), new VAvailability.Factory(), new VEvent.Factory(), new VFreeBusy.Factory(), new VJournal.Factory(), new VTimeZone.Factory(), new VToDo.Factory()));
    private final PropertyMapper propertyMapper = new PropertyMapperImpl(new DefaultPropertyFactorySupplier().get());
    private final ParameterMapper parameterMapper = new ParameterMapperImpl(new DefaultParameterFactorySupplier().get());

    public JCalMapper(Class<?> vc) {
    }

    public Calendar deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Calendar calendar = new Calendar();
        this.assertTextValue(p, "vcalendar");
        this.assertNextToken(p, JsonToken.START_ARRAY);
        while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
            calendar.add(this.propertyMapper.map(p));
        }
        this.assertNextToken(p, JsonToken.START_ARRAY);
        while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
            calendar.add((Component)((CalendarComponent)this.componentMapper.map(p)));
        }
        return calendar;
    }

    class ComponentMapperImpl
    implements ComponentMapper {
        private final List<ComponentFactory<?>> componentFactories;

        public ComponentMapperImpl(List<ComponentFactory<?>> componentFactories) {
            this.componentFactories = componentFactories;
        }

        @Override
        public Component map(JsonParser p) throws IOException {
            JCalMapper.this.assertCurrentToken(p, JsonToken.START_ARRAY);
            ComponentBuilder componentBuilder = new ComponentBuilder(this.componentFactories);
            componentBuilder.name(p.nextTextValue());
            JCalMapper.this.assertNextToken(p, JsonToken.START_ARRAY);
            while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
                componentBuilder.property(JCalMapper.this.propertyMapper.map(p));
            }
            JCalMapper.this.assertNextToken(p, JsonToken.START_ARRAY);
            while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
                componentBuilder.subComponent(this.map(p));
            }
            return componentBuilder.build();
        }
    }

    class PropertyMapperImpl
    implements PropertyMapper {
        private final List<PropertyFactory<?>> propertyFactories;

        public PropertyMapperImpl(List<PropertyFactory<?>> propertyFactories) {
            this.propertyFactories = propertyFactories;
        }

        @Override
        public Property map(JsonParser p) throws IOException {
            String propertyType;
            JCalMapper.this.assertCurrentToken(p, JsonToken.START_ARRAY);
            PropertyBuilder propertyBuilder = new PropertyBuilder(this.propertyFactories);
            propertyBuilder.name(p.nextTextValue());
            JCalMapper.this.assertNextToken(p, JsonToken.START_OBJECT);
            while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
                try {
                    propertyBuilder.parameter(JCalMapper.this.parameterMapper.map(p));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            switch (propertyType = p.nextTextValue()) {
                case "date": {
                    propertyBuilder.parameter((Parameter)Value.DATE);
                    propertyBuilder.value(JCalDecoder.DATE.decode(p.nextTextValue()));
                    break;
                }
                case "date-time": {
                    propertyBuilder.parameter((Parameter)Value.DATE_TIME);
                    propertyBuilder.value(JCalDecoder.DATE_TIME.decode(p.nextTextValue()));
                    break;
                }
                case "time": {
                    propertyBuilder.parameter((Parameter)Value.TIME);
                    propertyBuilder.value(JCalDecoder.TIME.decode(p.nextTextValue()));
                    break;
                }
                case "utc-offset": {
                    propertyBuilder.parameter((Parameter)Value.UTC_OFFSET);
                    propertyBuilder.value(JCalDecoder.UTCOFFSET.decode(p.nextTextValue()));
                    break;
                }
                case "binary": {
                    propertyBuilder.parameter((Parameter)Value.BINARY);
                }
                case "duration": {
                    propertyBuilder.parameter((Parameter)Value.DURATION);
                }
                case "period": {
                    propertyBuilder.parameter((Parameter)Value.PERIOD);
                }
                case "uri": {
                    propertyBuilder.parameter((Parameter)Value.URI);
                }
                default: {
                    propertyBuilder.value(p.nextTextValue());
                }
            }
            JCalMapper.this.assertNextToken(p, JsonToken.END_ARRAY);
            return propertyBuilder.build();
        }
    }
}

