/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jotn;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyContainer;
import net.fortuna.ical4j.model.PropertyFactory;
import org.mnode.ical4j.serializer.JsonMapper;

public interface JsonObjectMapper
extends JsonMapper {
    public List<ParameterFactory<?>> getParameterFactories();

    public List<PropertyFactory<?>> getPropertyFactories();

    default public <T extends PropertyContainer> T map(JsonParser p, T container) throws IOException {
        this.assertCurrentToken(p, JsonToken.START_OBJECT);
        while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
            this.assertCurrentToken(p, JsonToken.FIELD_NAME);
            String propertyName = p.currentName();
            try {
                if (JsonToken.START_ARRAY.equals((Object)p.nextToken())) {
                    container.addAll(this.parsePropertyList(p, propertyName));
                    continue;
                }
                container.add(this.parseProperty(p, propertyName));
            }
            catch (URISyntaxException | ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return container;
    }

    default public List<Property> parsePropertyList(JsonParser p, String propertyName) throws IOException, URISyntaxException, ParseException {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
            properties.add(this.parseProperty(p, propertyName));
        }
        return properties;
    }

    default public Property parseProperty(JsonParser p, String propertyName) throws IOException, URISyntaxException, ParseException {
        PropertyBuilder propertyBuilder = new PropertyBuilder(this.getPropertyFactories());
        propertyBuilder.name(propertyName);
        if (JsonToken.START_ARRAY.equals((Object)p.currentToken())) {
            StringBuilder b = new StringBuilder();
            while (!JsonToken.END_ARRAY.equals((Object)p.nextToken())) {
                this.assertCurrentToken(p, JsonToken.VALUE_STRING);
                b.append(p.getText());
                b.append(',');
            }
            propertyBuilder.value(b.toString());
        } else if (JsonToken.START_OBJECT.equals((Object)p.currentToken())) {
            while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
                this.assertCurrentToken(p, JsonToken.FIELD_NAME);
                if (this.isParameter(p.currentName())) {
                    propertyBuilder.parameter(this.parseParameter(p, this.getParameterFactories()));
                    continue;
                }
                this.assertNextScalarValue(p);
                propertyBuilder.value(this.decodeValue(propertyName, p.getText()));
            }
        } else {
            this.assertCurrentScalarValue(p);
            propertyBuilder.value(this.decodeValue(propertyName, p.getText()));
        }
        return propertyBuilder.build();
    }

    default public boolean isParameter(String fieldName) {
        return Arrays.asList("ABBREV", "CN", "ALTREP", "CUTYPE", "DIR", "DELEGATED-FROM", "DELEGATED-TO", "DISPLAY", "EMAIL", "ENCODING", "FBTYPE", "FEATURE", "FMTTYPE", "LABEL", "LANGUAGE", "MEMBER", "PARTSTAT", "RANGE", "RELATED", "RELTYPE", "ROLE", "RSVP", "SCHEDULE-AGENT", "SCHEDULE-STATUS", "SENT-BY", "TYPE", "TZID", "VALUE", "VVENUE").contains(fieldName.toUpperCase()) || fieldName.toUpperCase().startsWith("X-");
    }
}

