/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.parameter.Value;
import org.mnode.ical4j.serializer.JCalEncoder;

public interface JsonBuilder {
    default public ObjectNode putIfNotAbsent(String propertyName, ObjectNode node, Optional<Property> property) {
        property.ifPresent(value -> node.put(propertyName, this.encodeValue((Property)value)));
        return node;
    }

    default public ObjectNode putIfNotNull(String propertyName, ObjectNode node, String property) {
        if (property != null) {
            node.put(propertyName, property);
        }
        return node;
    }

    default public String encodeValue(Property property) {
        switch (property.getName().toLowerCase()) {
            case "trigger": 
            case "created": 
            case "last-modified": 
            case "dtstamp": {
                return JCalEncoder.INSTANT.encode(property.getValue());
            }
            case "dtstart": 
            case "dtend": 
            case "rdate": 
            case "exdate": 
            case "due": 
            case "recurrence-id": {
                if (property.getParameters(new String[]{"VALUE"}).contains(Value.DATE)) {
                    return JCalEncoder.DATE.encode(property.getValue());
                }
                return JCalEncoder.DATE_TIME.encode(property.getValue());
            }
        }
        return property.getValue();
    }
}

