/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.VCard;
import org.mnode.ical4j.serializer.jsonld.AbstractJsonLdSerializer;
import org.mnode.ical4j.serializer.jsonld.AbstractNodeBuilder;

public class PersonJsonLdSerializer
extends AbstractJsonLdSerializer<VCard> {
    public PersonJsonLdSerializer(Class<VCard> t) {
        super(t);
    }

    @Override
    protected JsonNode buildSchema(VCard card) {
        AbstractNodeBuilder<VCard> builder = new PersonNodeBuilder().component(card);
        return builder.build();
    }

    public static class PersonNodeBuilder
    extends AbstractNodeBuilder<VCard> {
        public PersonNodeBuilder() {
            super("Person");
        }

        @Override
        public JsonNode build() {
            ObjectNode node = this.createObjectNode();
            this.putIfNotAbsent("@id", node, (Enum<?>)PropertyName.UID);
            this.putIfNotAbsent("name", node, (Enum<?>)PropertyName.FN);
            this.putIfNotAbsent("email", node, (Enum<?>)PropertyName.EMAIL);
            this.putIfNotAbsent("image", node, (Enum<?>)PropertyName.PHOTO);
            this.putIfNotAbsent("jobTitle", node, (Enum<?>)PropertyName.TITLE);
            this.putIfNotAbsent("telephone", node, (Enum<?>)PropertyName.TEL);
            this.putIfNotAbsent("url", node, (Enum<?>)PropertyName.URL);
            this.setObject("address", node, (Enum<?>)PropertyName.ADR);
            return node;
        }
    }
}

