/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.jotn;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import net.fortuna.ical4j.vcard.VCard;
import org.apache.commons.codec.DecoderException;
import org.mnode.ical4j.serializer.jotn.AbstractVCardMapper;

public class VCardMapper
extends AbstractVCardMapper<VCard> {
    public VCardMapper(Class<VCard> t) {
        super(t);
    }

    public VCard deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        VCard card = new VCard();
        this.assertCurrentToken(p, JsonToken.START_OBJECT);
        while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
            this.assertCurrentToken(p, JsonToken.FIELD_NAME);
            String propertyName = p.currentName();
            try {
                if (JsonToken.START_ARRAY.equals((Object)p.nextToken())) {
                    card.addAll(this.parsePropertyList(propertyName, p));
                    continue;
                }
                card.add(this.parseProperty(propertyName, p));
            }
            catch (URISyntaxException | ParseException | DecoderException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return card;
    }
}

