/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.data.DefaultParameterFactorySupplier;
import net.fortuna.ical4j.data.DefaultPropertyFactorySupplier;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.component.Available;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.component.VVenue;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.vcard.VCard;
import org.mnode.ical4j.serializer.JCalDecoder;
import org.mnode.ical4j.serializer.JsonMapper;

public class XCardMapper
extends StdDeserializer<VCard>
implements JsonMapper {
    private final List<ParameterFactory<?>> parameterFactories = new DefaultParameterFactorySupplier().get();
    private final List<PropertyFactory<?>> propertyFactories = new DefaultPropertyFactorySupplier().get();
    private final List<ComponentFactory<?>> componentFactories = Arrays.asList(new Available.Factory(), new Daylight.Factory(), new Standard.Factory(), new VAlarm.Factory(), new VAvailability.Factory(), new VEvent.Factory(), new VFreeBusy.Factory(), new VJournal.Factory(), new VTimeZone.Factory(), new VToDo.Factory(), new VVenue.Factory());

    public XCardMapper(Class<?> vc) {
        super(vc);
    }

    public VCard deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        VCard card = new VCard();
        this.assertNextName(p, "vcalendar");
        this.assertNextToken(p, JsonToken.START_OBJECT);
        this.assertNextName(p, "properties");
        this.assertNextToken(p, JsonToken.START_OBJECT);
        while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
            try {
                card.add(this.parseProperty(p));
            }
            catch (URISyntaxException | ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return card;
    }

    private Property parseProperty(JsonParser p) throws IOException, URISyntaxException, ParseException {
        String propertyType;
        String propertyName = p.currentName();
        this.assertNextToken(p, JsonToken.START_OBJECT);
        PropertyBuilder propertyBuilder = new PropertyBuilder(this.propertyFactories);
        propertyBuilder.name(propertyName);
        this.assertNextName(p, "parameters");
        if (p.nextToken() != JsonToken.VALUE_STRING) {
            this.assertCurrentToken(p, JsonToken.START_OBJECT);
            while (!JsonToken.END_OBJECT.equals((Object)p.nextToken())) {
                try {
                    propertyBuilder.parameter(this.parseParameter(p, this.parameterFactories));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        switch (propertyType = p.nextFieldName()) {
            case "date": {
                propertyBuilder.parameter((Parameter)Value.DATE);
                propertyBuilder.value(JCalDecoder.DATE.decode(p.nextTextValue()));
                break;
            }
            case "date-time": {
                propertyBuilder.parameter((Parameter)Value.DATE_TIME);
                propertyBuilder.value(JCalDecoder.DATE_TIME.decode(p.nextTextValue()));
                break;
            }
            case "time": {
                propertyBuilder.parameter((Parameter)Value.TIME);
                propertyBuilder.value(JCalDecoder.TIME.decode(p.nextTextValue()));
                break;
            }
            case "utc-offset": {
                propertyBuilder.parameter((Parameter)Value.UTC_OFFSET);
                propertyBuilder.value(JCalDecoder.UTCOFFSET.decode(p.nextTextValue()));
                break;
            }
            case "binary": {
                propertyBuilder.parameter((Parameter)Value.BINARY);
            }
            case "duration": {
                propertyBuilder.parameter((Parameter)Value.DURATION);
            }
            case "period": {
                propertyBuilder.parameter((Parameter)Value.PERIOD);
            }
            case "uri": {
                propertyBuilder.parameter((Parameter)Value.URI);
            }
            default: {
                propertyBuilder.value(p.nextTextValue());
            }
        }
        this.assertNextToken(p, JsonToken.END_OBJECT);
        return null;
    }
}

