/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.command;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import org.mnode.ical4j.serializer.JCalSerializer;
import picocli.CommandLine;

@CommandLine.Command(name="calendar", description={"Transform input calendar data to specified format"})
public class SerializeCalendarCommand
implements Runnable {
    @CommandLine.Option(names={"-U", "--url"})
    private URL url;
    @CommandLine.Option(names={"-P", "--pretty-print"})
    private boolean prettyPrint;

    public SerializeCalendarCommand withUrl(URL url) {
        this.url = url;
        return this;
    }

    public String serialize() throws IOException, ParserException {
        CalendarBuilder builder = new CalendarBuilder();
        UnfoldingReader reader = new UnfoldingReader((Reader)new InputStreamReader(this.url.openStream()), true);
        Calendar cal = builder.build(reader);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Calendar.class, (JsonSerializer)new JCalSerializer(null));
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        if (this.prettyPrint) {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)cal);
        }
        return mapper.writeValueAsString((Object)cal);
    }

    @Override
    public void run() {
        try {
            System.out.print(this.serialize());
        }
        catch (IOException | ParserException e) {
            throw new RuntimeException(e);
        }
    }
}

