/*
 * Decompiled with CFR 0.152.
 */
package org.mnode.ical4j.serializer.command;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.mnode.ical4j.serializer.ICalendarSerializerServlet;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="jetty", description={"Start Jetty service for validation requests"})
public class JettyRunCommand
implements Runnable {
    @Override
    public void run() {
        Server server = new Server(8001);
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/serializer");
        ServletHolder servletHolder = context.addServlet(ICalendarSerializerServlet.class, "/");
        server.setHandler((Handler)context);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                System.out.println("Shutting down the application...");
                server.stop();
                System.out.println("Done, exit.");
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)JettyRunCommand.class.getName()).error("Unexpected error", (Throwable)e);
            }
        }));
        try {
            server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

