/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender.servermessage;

import nextapp.echo2.webrender.ServerMessage;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomUpdate {
    private static final String MESSAGE_PART_NAME = "EchoDomUpdate.MessageProcessor";
    private static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";

    public static void renderAttributeUpdate(ServerMessage serverMessage, String targetId, String attributeName, String attributeValue) {
        Element element = serverMessage.appendPartDirective("update", MESSAGE_PART_NAME, "attribute-update");
        element.setAttribute("target-id", targetId);
        element.setAttribute("name", attributeName);
        element.setAttribute("value", attributeValue);
    }

    public static Element renderElementAdd(ServerMessage serverMessage) {
        Element domAddElement = serverMessage.appendPartDirective("update", MESSAGE_PART_NAME, "dom-add");
        return domAddElement;
    }

    public static void renderElementAdd(ServerMessage serverMessage, String parentId, DocumentFragment htmlFragment) {
        DomUpdate.renderElementAdd(serverMessage, parentId, null, htmlFragment);
    }

    public static void renderElementAdd(ServerMessage serverMessage, String parentId, String siblingId, DocumentFragment htmlFragment) {
        DomUpdate.setContentNamespace(htmlFragment);
        Element domAddElement = serverMessage.appendPartDirective("update", MESSAGE_PART_NAME, "dom-add");
        Element contentElement = domAddElement.getOwnerDocument().createElement("content");
        contentElement.setAttribute("parent-id", parentId);
        if (siblingId != null) {
            contentElement.setAttribute("sibling-id", siblingId);
        }
        domAddElement.appendChild(contentElement);
        contentElement.appendChild(htmlFragment);
    }

    public static void renderElementAddContent(ServerMessage serverMessage, Element domAddElement, String parentId, DocumentFragment htmlFragment) {
        DomUpdate.renderElementAddContent(serverMessage, domAddElement, parentId, null, htmlFragment);
    }

    public static void renderElementAddContent(ServerMessage serverMessage, Element domAddElement, String parentId, String siblingId, DocumentFragment htmlFragment) {
        DomUpdate.setContentNamespace(htmlFragment);
        Element contentElement = domAddElement.getOwnerDocument().createElement("content");
        contentElement.setAttribute("parent-id", parentId);
        if (siblingId != null) {
            contentElement.setAttribute("sibling-id", siblingId);
        }
        domAddElement.appendChild(contentElement);
        contentElement.appendChild(htmlFragment);
    }

    public static void renderElementRemove(ServerMessage serverMessage, String targetId) {
        Element domRemoveElement = serverMessage.appendPartDirective("remove", MESSAGE_PART_NAME, "dom-remove");
        domRemoveElement.setAttribute("target-id", targetId);
    }

    public static void renderElementRemoveChildren(ServerMessage serverMessage, String targetId) {
        Element domRemoveElement = serverMessage.appendPartDirective("remove", MESSAGE_PART_NAME, "dom-remove-children");
        domRemoveElement.setAttribute("target-id", targetId);
    }

    public static void renderStyleUpdate(ServerMessage serverMessage, String targetId, String attributeName, String attributeValue) {
        Element element = serverMessage.appendPartDirective("update", MESSAGE_PART_NAME, "style-update");
        element.setAttribute("target-id", targetId);
        element.setAttribute("name", attributeName);
        element.setAttribute("value", attributeValue);
    }

    public static void renderStyleSheetAddRule(ServerMessage serverMessage, String selectorText, String style) {
        Element element = serverMessage.appendPartDirective("update", MESSAGE_PART_NAME, "stylesheet-add-rule");
        element.setAttribute("selector", selectorText);
        element.setAttribute("style", style);
    }

    public static void renderStyleSheetRemoveRule(ServerMessage serverMessage, String selectorText) {
        Element element = serverMessage.appendPartDirective("update", MESSAGE_PART_NAME, "stylesheet-remove-rule");
        element.setAttribute("selector", selectorText);
    }

    private static void setContentNamespace(DocumentFragment htmlFragment) {
        for (Node childNode = htmlFragment.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            ((Element)childNode).setAttribute("xmlns", XHTML_NAMESPACE);
        }
    }
}

