/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import nextapp.echo2.webrender.ClientConfiguration;
import nextapp.echo2.webrender.ClientProperties;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ServerDelayMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.UserInstanceUpdateManager;

public abstract class UserInstance
implements HttpSessionActivationListener,
HttpSessionBindingListener {
    public static final String PROPERTY_CLIENT_CONFIGURATION = "clientConfiguration";
    public static final String PROPERTY_SERVER_DELAY_MESSAGE = "serverDelayMessage";
    private String characterEncoding = "UTF-8";
    private ClientConfiguration clientConfiguration;
    private ServerDelayMessage serverDelayMessage;
    private ClientProperties clientProperties;
    private String servletUri;
    private transient HttpSession session;
    private UserInstanceUpdateManager updateManager = new UserInstanceUpdateManager();
    private long transactionId = 0L;

    public UserInstance(Connection conn) {
        conn.initUserInstance(this);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    public long getCurrentTransactionId() {
        return this.transactionId;
    }

    public long getNextTransactionId() {
        ++this.transactionId;
        return this.transactionId;
    }

    public ServerDelayMessage getServerDelayMessage() {
        return this.serverDelayMessage;
    }

    public String getServiceUri(Service service) {
        return this.servletUri + "?serviceId=" + service.getId();
    }

    public String getServiceUri(Service service, String[] parameterNames, String[] parameterValues) {
        StringBuffer out = new StringBuffer(this.servletUri);
        out.append("?serviceId=");
        out.append(service.getId());
        for (int i = 0; i < parameterNames.length; ++i) {
            out.append("&");
            out.append(parameterNames[i]);
            if (parameterValues[i] == null) continue;
            out.append("=");
            out.append(parameterValues[i]);
        }
        return out.toString();
    }

    public String getServletUri() {
        return this.servletUri;
    }

    public UserInstanceUpdateManager getUserInstanceUpdateManager() {
        return this.updateManager;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void sessionDidActivate(HttpSessionEvent e) {
        this.session = e.getSession();
    }

    public void sessionWillPassivate(HttpSessionEvent e) {
        this.session = null;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.updateManager.processPropertyUpdate(PROPERTY_CLIENT_CONFIGURATION);
    }

    void setClientProperties(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void setServerDelayMessage(ServerDelayMessage serverDelayMessage) {
        this.serverDelayMessage = serverDelayMessage;
        this.updateManager.processPropertyUpdate(PROPERTY_SERVER_DELAY_MESSAGE);
    }

    void setServletUri(String servletUri) {
        this.servletUri = servletUri;
    }

    public void valueBound(HttpSessionBindingEvent e) {
        this.session = e.getSession();
    }

    public void valueUnbound(HttpSessionBindingEvent e) {
        this.session = null;
    }
}

