/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.webrender.output.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerMessage
extends XmlDocument {
    public static final int LEFT_TO_RIGHT = 0;
    public static final int RIGHT_TO_LEFT = 1;
    private Map itemizedDirectivesMap = new HashMap();
    public static final String GROUP_ID_INIT = "init";
    public static final String GROUP_ID_PREREMOVE = "preremove";
    public static final String GROUP_ID_REMOVE = "remove";
    public static final String GROUP_ID_UPDATE = "update";
    public static final String GROUP_ID_POSTUPDATE = "postupdate";
    private Set addedLibraries;
    private Element librariesElement;
    private Element serverMessageElement;

    public ServerMessage() {
        super("server-message", null, null, "http://www.nextapp.com/products/echo2/svrmsg/servermessage");
        Document document = this.getDocument();
        this.serverMessageElement = document.getDocumentElement();
        this.librariesElement = document.createElement("libraries");
        this.serverMessageElement.appendChild(this.librariesElement);
        this.addPartGroup(GROUP_ID_INIT);
        this.addPartGroup(GROUP_ID_PREREMOVE);
        this.addPartGroup(GROUP_ID_REMOVE);
        this.addPartGroup(GROUP_ID_UPDATE);
        this.addPartGroup(GROUP_ID_POSTUPDATE);
    }

    public void addLibrary(String serviceId) {
        if (this.addedLibraries == null) {
            this.addedLibraries = new HashSet();
        }
        if (this.addedLibraries.contains(serviceId)) {
            return;
        }
        Element libraryElement = this.getDocument().createElement("library");
        libraryElement.setAttribute("service-id", serviceId);
        this.librariesElement.appendChild(libraryElement);
        this.addedLibraries.add(serviceId);
    }

    public Element addPartGroup(String groupId) {
        Element messagePartGroupElement = this.getDocument().createElement("message-part-group");
        messagePartGroupElement.setAttribute("id", groupId);
        this.serverMessageElement.appendChild(messagePartGroupElement);
        return messagePartGroupElement;
    }

    public Element getPartGroup(String groupId) {
        NodeList groupList = this.serverMessageElement.getElementsByTagName("message-part-group");
        int length = groupList.getLength();
        for (int i = 0; i < length; ++i) {
            Element groupElement = (Element)groupList.item(i);
            if (!groupId.equals(groupElement.getAttribute("id"))) continue;
            return groupElement;
        }
        return null;
    }

    public Element addPart(String groupId, String processor) {
        Element messagePartGroupElement = this.getPartGroup(groupId);
        Element messagePartElement = this.getDocument().createElement("message-part");
        messagePartElement.setAttribute("processor", processor);
        messagePartGroupElement.appendChild(messagePartElement);
        return messagePartElement;
    }

    public Element appendPartDirective(String groupId, String processor, String directiveName) {
        Element messagePartElement = null;
        Element groupElement = this.getPartGroup(groupId);
        Element lastChild = (Element)groupElement.getLastChild();
        messagePartElement = lastChild != null && processor.equals(lastChild.getAttribute("processor")) ? lastChild : this.addPart(groupId, processor);
        Element directiveElement = this.getDocument().createElement(directiveName);
        messagePartElement.appendChild(directiveElement);
        return directiveElement;
    }

    public Element getItemizedDirective(String groupId, String processor, String directiveName, String[] keyAttributeNames, String[] keyAttributeValues) {
        ItemizedDirectiveLookupKey itemizedDirectiveLookupKey = new ItemizedDirectiveLookupKey(groupId, processor, directiveName, keyAttributeNames, keyAttributeValues);
        Element element = (Element)this.itemizedDirectivesMap.get(itemizedDirectiveLookupKey);
        if (element == null) {
            element = this.appendPartDirective(groupId, processor, directiveName);
            for (int i = 0; i < keyAttributeNames.length; ++i) {
                element.setAttribute(keyAttributeNames[i], keyAttributeValues[i]);
            }
            this.itemizedDirectivesMap.put(itemizedDirectiveLookupKey, element);
        }
        return element;
    }

    public void setAsynchronousMonitorInterval(int newValue) {
        if (newValue < 0) {
            this.serverMessageElement.setAttribute("async-interval", "disable");
        } else {
            this.serverMessageElement.setAttribute("async-interval", Integer.toString(newValue));
        }
    }

    public void setModalContextRootId(String id) {
        if (id == null) {
            this.serverMessageElement.setAttribute("modal-id", "");
        } else {
            this.serverMessageElement.setAttribute("modal-id", id);
        }
    }

    public void setRootLayoutDirection(int layoutDirection) {
        switch (layoutDirection) {
            case 0: {
                this.serverMessageElement.setAttribute("root-layout-direction", "ltr");
                break;
            }
            case 1: {
                this.serverMessageElement.setAttribute("root-layout-direction", "rtl");
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal layout direction.");
            }
        }
    }

    public void setTransactionId(long transactionId) {
        this.serverMessageElement.setAttribute("trans-id", Long.toString(transactionId));
    }

    private class ItemizedDirectiveLookupKey {
        String groupId;
        String processor;
        String directiveName;
        String[] keyAttributeNames;
        String[] keyAttributeValues;
        int hashCode;

        private ItemizedDirectiveLookupKey(String groupId, String processor, String directiveName, String[] keyAttributeNames, String[] keyAttributeValues) {
            this.groupId = groupId;
            this.processor = processor;
            this.directiveName = directiveName;
            this.keyAttributeNames = keyAttributeNames;
            this.keyAttributeValues = keyAttributeValues;
            this.hashCode = groupId.hashCode() ^ processor.hashCode() ^ directiveName.hashCode();
            for (int i = 0; i < keyAttributeNames.length; ++i) {
                this.hashCode ^= keyAttributeNames[i].hashCode() ^ keyAttributeValues[i].hashCode();
            }
        }

        public boolean equals(Object o) {
            int i;
            if (!(o instanceof ItemizedDirectiveLookupKey)) {
                return false;
            }
            ItemizedDirectiveLookupKey that = (ItemizedDirectiveLookupKey)o;
            if (!this.groupId.equals(that.groupId)) {
                return false;
            }
            if (!this.processor.equals(that.processor)) {
                return false;
            }
            if (!this.directiveName.equals(that.directiveName)) {
                return false;
            }
            if (this.keyAttributeNames.length != that.keyAttributeNames.length) {
                return false;
            }
            for (i = 0; i < this.keyAttributeValues.length; ++i) {
                if (this.keyAttributeValues[i].equals(that.keyAttributeValues[i])) continue;
                return false;
            }
            for (i = 0; i < this.keyAttributeNames.length; ++i) {
                if (this.keyAttributeNames[i].equals(that.keyAttributeNames[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

