/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.UserInstance;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.WebRenderServletException;

public class Connection {
    private static final String USER_INSTANCE_SESSION_KEY_PREFIX = "Echo2UserInstance";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private WebRenderServlet servlet;
    private UserInstance userInstance;
    private Map propertyMap;

    Connection(WebRenderServlet servlet, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session;
        this.servlet = servlet;
        this.request = request;
        this.response = response;
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith(ContentType.MULTIPART_FORM_DATA.getMimeType())) {
            if (WebRenderServlet.getMultipartRequestWrapper() == null) {
                throw new WebRenderServletException("MultipartRequestWrapper was never set and client made an HTTP request encoded as multipart/form-data.");
            }
            this.request = WebRenderServlet.getMultipartRequestWrapper().getWrappedRequest(request);
        }
        if ((session = request.getSession(false)) != null) {
            this.userInstance = (UserInstance)session.getAttribute(this.getSessionKey());
        }
    }

    void disposeUserInstance() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            this.getUserInstance().setServletUri(null);
            session.removeAttribute(this.getSessionKey());
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException ex) {
            throw new WebRenderServletException("Unable to get PrintWriter.", ex);
        }
    }

    public Object getProperty(String key) {
        return this.propertyMap == null ? null : this.propertyMap.get(key);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    private String getSessionKey() {
        return "Echo2UserInstance:" + this.servlet.getServletName();
    }

    public WebRenderServlet getServlet() {
        return this.servlet;
    }

    public UserInstance getUserInstance() {
        return this.userInstance;
    }

    public PrintWriter getWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException ex) {
            throw new WebRenderServletException("Unable to get PrintWriter.", ex);
        }
    }

    void initUserInstance(UserInstance userInstance) {
        this.userInstance = userInstance;
        userInstance.setServletUri(this.request.getRequestURI());
        HttpSession session = this.request.getSession(true);
        session.setAttribute(this.getSessionKey(), (Object)userInstance);
    }

    public void setContentType(ContentType contentType) {
        UserInstance userInstance = this.getUserInstance();
        if (contentType.isBinary() || userInstance == null) {
            this.response.setContentType(contentType.getMimeType());
        } else {
            this.response.setContentType(contentType.getMimeType() + "; charset=" + userInstance.getCharacterEncoding());
        }
    }

    public void setProperty(String key, Object value) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        this.propertyMap.put(key, value);
    }
}

