/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender;

import java.util.Properties;
import nextapp.echo2.webrender.output.HtmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseHtmlDocument
extends HtmlDocument {
    private static final Properties OUTPUT_PROPERTIES = new Properties();
    private String contentId;

    public BaseHtmlDocument(String contentId) {
        super("-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", "http://www.w3.org/1999/xhtml");
        this.setOutputProperties(OUTPUT_PROPERTIES);
        this.contentId = contentId;
        Document document = this.getDocument();
        Element styleElement = document.createElement("style");
        styleElement.setAttribute("type", "text/css");
        styleElement.appendChild(document.createTextNode(" "));
        this.getHeadElement().appendChild(styleElement);
        Element formElement = document.createElement("form");
        formElement.setAttribute("style", "padding:0px;margin:0px;");
        formElement.setAttribute("action", "#");
        formElement.setAttribute("id", contentId);
        formElement.setAttribute("onsubmit", "return false;");
        Element loadingDiv = document.createElement("div");
        loadingDiv.setAttribute("id", "loadstatus");
        loadingDiv.appendChild(document.createTextNode("//"));
        formElement.appendChild(loadingDiv);
        this.getBodyElement().appendChild(formElement);
    }

    public Element getContentElement() {
        return this.getDocument().getElementById(this.contentId);
    }

    static {
        OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        OUTPUT_PROPERTIES.setProperty("doctype-public", "-//W3C//DTD XHTML 1.0 Transitional//EN");
        OUTPUT_PROPERTIES.setProperty("doctype-system", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
    }
}

