/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo2.app.RenderIdSupport;

public class IdTable
implements Serializable {
    private boolean hasHardReferences = false;
    private transient Map idToReferenceMap = new HashMap();
    private transient ReferenceQueue referenceQueue = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RenderIdSupport object) {
        this.purge();
        String id = object.getRenderId();
        Map map = this.idToReferenceMap;
        synchronized (map) {
            if (!this.idToReferenceMap.containsKey(id)) {
                WeakReference<RenderIdSupport> weakReference = new WeakReference<RenderIdSupport>(object, this.referenceQueue);
                this.idToReferenceMap.put(id, weakReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String id) {
        WeakReference weakReference;
        this.purge();
        Map map = this.idToReferenceMap;
        synchronized (map) {
            weakReference = (WeakReference)this.idToReferenceMap.get(id);
        }
        if (weakReference == null) {
            return null;
        }
        Object object = weakReference.get();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        Reference reference;
        if (this.hasHardReferences) {
            Map map = this.idToReferenceMap;
            synchronized (map) {
                for (String id : this.idToReferenceMap.keySet()) {
                    Object object = this.idToReferenceMap.get(id);
                    if (object instanceof WeakReference) continue;
                    WeakReference weakReference = new WeakReference(object, this.referenceQueue);
                    this.idToReferenceMap.put(id, weakReference);
                }
                this.hasHardReferences = false;
            }
        }
        if ((reference = this.referenceQueue.poll()) == null) {
            return;
        }
        HashSet referenceSet = new HashSet();
        while (reference != null) {
            referenceSet.add(reference);
            reference = this.referenceQueue.poll();
        }
        Map map = this.idToReferenceMap;
        synchronized (map) {
            Iterator idIt = this.idToReferenceMap.keySet().iterator();
            while (idIt.hasNext()) {
                String id = (String)idIt.next();
                if (!referenceSet.contains(this.idToReferenceMap.get(id))) continue;
                idIt.remove();
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.idToReferenceMap = new HashMap();
        this.referenceQueue = new ReferenceQueue();
        String id = (String)in.readObject();
        if (id != null) {
            this.hasHardReferences = true;
            while (id != null) {
                RenderIdSupport object = (RenderIdSupport)in.readObject();
                this.idToReferenceMap.put(id, object);
                id = (String)in.readObject();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (String id : this.idToReferenceMap.keySet()) {
            out.writeObject(id);
            Object object = this.idToReferenceMap.get(id);
            if (object instanceof WeakReference) {
                object = ((WeakReference)object).get();
            }
            out.writeObject(object);
        }
        out.writeObject(null);
    }
}

