/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.GridLayoutData;

public class GridProcessor {
    private static final Integer DEFAULT_SIZE = new Integer(2);
    private Grid grid;
    private List cellArrays;
    private int gridXSize;
    private int gridYSize;
    private List xExtents;
    private List yExtents;
    private boolean horizontalOrientation;

    public GridProcessor(Grid grid) {
        this.grid = grid;
        this.cellArrays = new ArrayList();
        Integer orientationValue = (Integer)grid.getRenderProperty("orientation");
        int orientation = orientationValue == null ? 0 : orientationValue;
        this.horizontalOrientation = orientation != 1;
        Cell[] cells = this.createCells();
        if (cells == null) {
            this.gridXSize = 0;
            this.gridYSize = 0;
            return;
        }
        this.renderCellMatrix(cells);
        this.calculateExtents();
        this.reduceY();
        this.reduceX();
        this.trimX();
    }

    private void calculateExtents() {
        int i;
        String xProperty = this.horizontalOrientation ? "columnWidth" : "rowHeight";
        String yProperty = this.horizontalOrientation ? "rowHeight" : "columnWidth";
        this.xExtents = new ArrayList();
        for (i = 0; i < this.gridXSize; ++i) {
            this.xExtents.add(this.grid.getRenderIndexedProperty(xProperty, i));
        }
        this.yExtents = new ArrayList();
        for (i = 0; i < this.gridYSize; ++i) {
            this.yExtents.add(this.grid.getRenderIndexedProperty(yProperty, i));
        }
    }

    private Cell[] createCells() {
        Component[] children = this.grid.getVisibleComponents();
        if (children.length == 0) {
            return null;
        }
        Cell[] cells = new Cell[children.length];
        for (int i = 0; i < children.length; ++i) {
            LayoutData layoutData = (LayoutData)children[i].getRenderProperty("layoutData");
            if (layoutData instanceof GridLayoutData) {
                GridLayoutData gcLayoutData = (GridLayoutData)layoutData;
                int xSpan = this.horizontalOrientation ? gcLayoutData.getColumnSpan() : gcLayoutData.getRowSpan();
                int ySpan = this.horizontalOrientation ? gcLayoutData.getRowSpan() : gcLayoutData.getColumnSpan();
                cells[i] = new Cell(children[i], i, xSpan, ySpan);
                continue;
            }
            cells[i] = new Cell(children[i], i, 1, 1);
        }
        return cells;
    }

    private Cell[] getCellArray(int y, boolean expand) {
        while (expand && y >= this.cellArrays.size()) {
            this.cellArrays.add(new Cell[this.gridXSize]);
        }
        return (Cell[])this.cellArrays.get(y);
    }

    public Component getContent(int column, int row) {
        if (this.horizontalOrientation) {
            Cell cell = this.getCellArray(row, false)[column];
            return cell == null ? null : cell.component;
        }
        Cell cell = this.getCellArray(column, false)[row];
        return cell == null ? null : cell.component;
    }

    public int getComponentIndex(int column, int row) {
        if (this.horizontalOrientation) {
            Cell cell = this.getCellArray(row, false)[column];
            return cell == null ? -1 : cell.index;
        }
        Cell cell = this.getCellArray(column, false)[row];
        return cell == null ? -1 : cell.index;
    }

    public int getColumnCount() {
        return this.horizontalOrientation ? this.gridXSize : this.gridYSize;
    }

    public int getRowCount() {
        return this.horizontalOrientation ? this.gridYSize : this.gridXSize;
    }

    public Extent getColumnWidth(int column) {
        return (Extent)(this.horizontalOrientation ? this.xExtents : this.yExtents).get(column);
    }

    public Extent getRowHeight(int row) {
        return (Extent)(this.horizontalOrientation ? this.yExtents : this.xExtents).get(row);
    }

    public int getColumnSpan(int column, int row) {
        if (this.horizontalOrientation) {
            Cell cell = this.getCellArray(row, false)[column];
            return cell == null ? -1 : cell.xSpan;
        }
        Cell cell = this.getCellArray(column, false)[row];
        return cell == null ? -1 : cell.ySpan;
    }

    public int getRowSpan(int column, int row) {
        if (this.horizontalOrientation) {
            Cell cell = this.getCellArray(row, false)[column];
            return cell == null ? -1 : cell.ySpan;
        }
        Cell cell = this.getCellArray(column, false)[row];
        return cell == null ? -1 : cell.xSpan;
    }

    private void reduceX() {
        int x;
        BitSet xRemoves = new BitSet();
        int length = this.getCellArray(0, false).length;
        for (x = 1; x < length; ++x) {
            boolean identical = true;
            for (int y = 0; y < this.cellArrays.size(); ++y) {
                if (this.getCellArray(y, false)[x] == this.getCellArray(y, false)[x - 1]) continue;
                identical = false;
                break;
            }
            if (!identical) continue;
            xRemoves.set(x, true);
        }
        if (xRemoves.nextSetBit(0) == -1) {
            return;
        }
        for (int removedX = this.gridXSize - 1; removedX >= 0; --removedX) {
            if (!xRemoves.get(removedX)) continue;
            for (int y = 0; y < this.gridYSize; ++y) {
                Cell[] cellArray;
                if ((y == 0 || this.getCellArray(y, false)[removedX - 1] != this.getCellArray(y - 1, false)[removedX - 1]) && (cellArray = this.getCellArray(y, false))[removedX - 1] != null) {
                    --this.getCellArray(y, false)[removedX - 1].xSpan;
                }
                for (x = removedX; x < this.gridXSize - 1; ++x) {
                    this.getCellArray((int)y, (boolean)false)[x] = this.getCellArray(y, false)[x + 1];
                }
            }
            Extent retainedExtent = (Extent)this.xExtents.get(removedX - 1);
            Extent removedExtent = (Extent)this.xExtents.get(removedX);
            this.xExtents.remove(removedX);
            if (removedExtent != null) {
                this.xExtents.set(removedX - 1, Extent.add(removedExtent, retainedExtent));
            }
            --this.gridXSize;
        }
    }

    private void reduceY() {
        BitSet yRemoves = new BitSet();
        int size = this.cellArrays.size();
        Cell[] currentCellArray = this.getCellArray(0, false);
        for (int y = 1; y < size; ++y) {
            Cell[] previousCellArray = currentCellArray;
            currentCellArray = this.getCellArray(y, false);
            boolean identical = true;
            for (int x = 0; x < currentCellArray.length; ++x) {
                if (currentCellArray[x] == previousCellArray[x]) continue;
                identical = false;
                break;
            }
            if (!identical) continue;
            yRemoves.set(y, true);
        }
        if (yRemoves.nextSetBit(0) == -1) {
            return;
        }
        for (int removedY = this.gridYSize - 1; removedY >= 0; --removedY) {
            if (!yRemoves.get(removedY)) continue;
            Cell[] retainedCellArray = this.getCellArray(removedY - 1, false);
            for (int x = 0; x < this.gridXSize; ++x) {
                if (x != 0 && retainedCellArray[x] == retainedCellArray[x - 1] || retainedCellArray[x] == null) continue;
                --retainedCellArray[x].ySpan;
            }
            this.cellArrays.remove(removedY);
            Extent retainedExtent = (Extent)this.yExtents.get(removedY - 1);
            Extent removedExtent = (Extent)this.yExtents.get(removedY);
            this.yExtents.remove(removedY);
            if (removedExtent != null) {
                this.yExtents.set(removedY - 1, Extent.add(removedExtent, retainedExtent));
            }
            --this.gridYSize;
        }
    }

    private void renderCellMatrix(Cell[] cells) {
        this.gridXSize = (Integer)this.grid.getRenderProperty("size", DEFAULT_SIZE);
        int x = 0;
        int y = 0;
        Cell[] yCells = this.getCellArray(y, true);
        for (int componentIndex = 0; componentIndex < cells.length; ++componentIndex) {
            if (cells[componentIndex].xSpan == -1 || cells[componentIndex].xSpan > this.gridXSize - x) {
                cells[componentIndex].xSpan = this.gridXSize - x;
            }
            if (cells[componentIndex].xSpan < 1) {
                cells[componentIndex].xSpan = 1;
            }
            if (cells[componentIndex].ySpan < 1) {
                cells[componentIndex].ySpan = 1;
            }
            if (cells[componentIndex].xSpan != 1 || cells[componentIndex].ySpan != 1) {
                for (int xIndex = 1; xIndex < cells[componentIndex].xSpan; ++xIndex) {
                    if (yCells[x + xIndex] == null) continue;
                    cells[componentIndex].xSpan = xIndex;
                    break;
                }
                for (int yIndex = 0; yIndex < cells[componentIndex].ySpan; ++yIndex) {
                    Cell[] yIndexCells = this.getCellArray(y + yIndex, true);
                    for (int xIndex = 0; xIndex < cells[componentIndex].xSpan; ++xIndex) {
                        yIndexCells[x + xIndex] = cells[componentIndex];
                    }
                }
            }
            yCells[x] = cells[componentIndex];
            if (componentIndex >= cells.length - 1) continue;
            boolean nextRenderPointFound = false;
            while (!nextRenderPointFound) {
                if (x < this.gridXSize - 1) {
                    ++x;
                } else {
                    x = 0;
                    yCells = this.getCellArray(++y, true);
                }
                nextRenderPointFound = yCells[x] == null;
            }
        }
        this.gridYSize = this.cellArrays.size();
    }

    private void trimX() {
        if (this.gridYSize == 1) {
            Cell[] cellArray = this.getCellArray(0, false);
            for (int i = 0; i < this.gridXSize; ++i) {
                if (cellArray[i] != null) continue;
                this.gridXSize = i;
            }
        }
    }

    private class Cell {
        private int xSpan;
        private int ySpan;
        private Component component;
        private int index;

        private Cell(Component component, int index, int xSpan, int ySpan) {
            this.component = component;
            this.index = index;
            this.xSpan = xSpan;
            this.ySpan = ySpan;
        }
    }
}

