/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.FloatingPane;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.servermessage.VirtualPosition;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContentPanePeer
implements ComponentSynchronizePeer,
DomUpdateSupport,
ImageRenderSupport,
PropertyUpdateProcessor {
    private static final Extent EXTENT_0 = new Extent(0);
    private static final Insets DEFAULT_INSETS = new Insets(EXTENT_0);
    private static final String IMAGE_ID_BACKGROUND = "background";
    private static final Service CONTENT_PANE_SERVICE = JavaScriptService.forResource("Echo.ContentPane", "/nextapp/echo2/webcontainer/resource/js/ContentPane.js");
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public ContentPanePeer() {
        this.partialUpdateManager.add("horizontalScroll", new PartialUpdateParticipant(){

            @Override
            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                ContentPanePeer.this.renderScrollDirective(rc, (ContentPane)update.getParent(), true);
            }

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }
        });
        this.partialUpdateManager.add("verticalScroll", new PartialUpdateParticipant(){

            @Override
            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                ContentPanePeer.this.renderScrollDirective(rc, (ContentPane)update.getParent(), false);
            }

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }
        });
    }

    @Override
    public String getContainerId(Component child) {
        return this.getContainerId(child.getParent(), child);
    }

    private String getContainerId(Component parent, Component child) {
        if (child instanceof FloatingPane) {
            return ContainerInstance.getElementId(parent) + "_float_" + ContainerInstance.getElementId(child);
        }
        return ContainerInstance.getElementId(parent) + "_content_" + ContainerInstance.getElementId(child);
    }

    @Override
    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("backgroundImage");
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        return null;
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd(rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent(rc.getServerMessage(), domAddElement, targetId, htmlFragment);
    }

    private void renderAddChildren(RenderContext rc, ServerComponentUpdate update) {
        ContentPane contentPane = (ContentPane)update.getParent();
        String elementId = ContainerInstance.getElementId(contentPane);
        Component[] components = update.getParent().getVisibleComponents();
        Component[] addedChildren = update.getAddedChildren();
        for (int componentIndex = components.length - 1; componentIndex >= 0; --componentIndex) {
            boolean childFound = false;
            for (int addedChildrenIndex = 0; !childFound && addedChildrenIndex < addedChildren.length; ++addedChildrenIndex) {
                if (addedChildren[addedChildrenIndex] != components[componentIndex]) continue;
                Element domAddElement = DomUpdate.renderElementAdd(rc.getServerMessage());
                DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
                this.renderChild(rc, update, htmlFragment, contentPane, components[componentIndex]);
                if (componentIndex == components.length - 1) {
                    DomUpdate.renderElementAddContent(rc.getServerMessage(), domAddElement, elementId, htmlFragment);
                } else {
                    DomUpdate.renderElementAddContent(rc.getServerMessage(), domAddElement, elementId, this.getContainerId(components[componentIndex + 1]), htmlFragment);
                }
                childFound = true;
            }
        }
    }

    private void renderChild(RenderContext rc, ServerComponentUpdate update, Node parentNode, ContentPane contentPane, Component child) {
        Element containerDivElement = parentNode.getOwnerDocument().createElement("div");
        String containerId = this.getContainerId(child);
        containerDivElement.setAttribute("id", containerId);
        if (!(child instanceof FloatingPane)) {
            CssStyle style = new CssStyle();
            style.setAttribute("position", "absolute");
            style.setAttribute("overflow", "auto");
            style.setAttribute("z-index", "0");
            Insets insets = (Insets)contentPane.getRenderProperty("insets", DEFAULT_INSETS);
            style.setAttribute("top", ExtentRender.renderCssAttributePixelValue(insets.getTop(), "0"));
            style.setAttribute("left", ExtentRender.renderCssAttributePixelValue(insets.getLeft(), "0"));
            style.setAttribute("right", ExtentRender.renderCssAttributePixelValue(insets.getRight(), "0"));
            style.setAttribute("bottom", ExtentRender.renderCssAttributePixelValue(insets.getBottom(), "0"));
            containerDivElement.setAttribute("style", style.renderInline());
            VirtualPosition.renderRegister(rc.getServerMessage(), containerId);
        }
        parentNode.appendChild(containerDivElement);
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, containerDivElement, child);
        } else {
            syncPeer.renderAdd(rc, update, containerId, child);
        }
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(CONTENT_PANE_SERVICE.getId());
        this.renderDisposeDirective(rc, (ContentPane)component);
    }

    private void renderDisposeDirective(RenderContext rc, ContentPane contentPane) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EchoContentPane.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(contentPane));
        itemizedUpdateElement.appendChild(itemElement);
    }

    @Override
    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        ContentPane contentPane = (ContentPane)component;
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(CONTENT_PANE_SERVICE.getId());
        Document document = parentNode.getOwnerDocument();
        Element divElement = document.createElement("div");
        divElement.setAttribute("id", ContainerInstance.getElementId(component));
        CssStyle cssStyle = new CssStyle();
        cssStyle.setAttribute("position", "absolute");
        cssStyle.setAttribute("width", "100%");
        cssStyle.setAttribute("height", "100%");
        cssStyle.setAttribute("overflow", "hidden");
        cssStyle.setAttribute("z-index", "0");
        ColorRender.renderToStyle(cssStyle, (Color)contentPane.getRenderProperty("foreground"), (Color)contentPane.getRenderProperty(IMAGE_ID_BACKGROUND));
        FontRender.renderToStyle(cssStyle, (Font)contentPane.getRenderProperty("font"));
        FillImageRender.renderToStyle(cssStyle, rc, this, contentPane, IMAGE_ID_BACKGROUND, (FillImage)contentPane.getRenderProperty("backgroundImage"), 0);
        divElement.setAttribute("style", cssStyle.renderInline());
        parentNode.appendChild(divElement);
        this.renderInitDirective(rc, contentPane);
        Component[] children = contentPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            this.renderChild(rc, update, divElement, contentPane, children[i]);
        }
    }

    private void renderInitDirective(RenderContext rc, ContentPane contentPane) {
        Extent verticalScroll;
        String elementId = ContainerInstance.getElementId(contentPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EchoContentPane.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        Extent horizontalScroll = (Extent)contentPane.getRenderProperty("horizontalScroll");
        if (horizontalScroll != null && horizontalScroll.getValue() != 0) {
            itemElement.setAttribute("horizontal-scroll", ExtentRender.renderCssAttributeValue(horizontalScroll));
        }
        if ((verticalScroll = (Extent)contentPane.getRenderProperty("verticalScroll")) != null && verticalScroll.getValue() != 0) {
            itemElement.setAttribute("vertical-scroll", ExtentRender.renderCssAttributeValue(verticalScroll));
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    private void renderScrollDirective(RenderContext rc, ContentPane contentPane, boolean horizontal) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element scrollElement = serverMessage.appendPartDirective("postupdate", "EchoContentPane.MessageProcessor", horizontal ? "scroll-horizontal" : "scroll-vertical");
        Extent position = (Extent)contentPane.getRenderProperty(horizontal ? "horizontalScroll" : "verticalScroll", EXTENT_0);
        scrollElement.setAttribute("eid", ContainerInstance.getElementId(contentPane));
        scrollElement.setAttribute("position", ExtentRender.renderCssAttributeValue(position));
    }

    private void renderRemoveChildren(RenderContext rc, ServerComponentUpdate update) {
        Component[] removedChildren = update.getRemovedChildren();
        for (int i = 0; i < removedChildren.length; ++i) {
            DomUpdate.renderElementRemove(rc.getServerMessage(), this.getContainerId(update.getParent(), removedChildren[i]));
        }
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.partialUpdateManager.process(rc, update);
            if (update.hasAddedChildren() || update.hasRemovedChildren()) {
                this.renderContentChange(rc, update);
            }
        }
        return fullReplace;
    }

    private void renderContentChange(RenderContext rc, ServerComponentUpdate update) {
        boolean primaryContentChanged = false;
        Component[] addedChildren = update.getAddedChildren();
        for (int i = 0; i < addedChildren.length; ++i) {
            if (addedChildren[i] instanceof FloatingPane) continue;
            primaryContentChanged = true;
            break;
        }
        if (!primaryContentChanged) {
            Component[] removedChildren = update.getRemovedChildren();
            for (int i = 0; i < removedChildren.length; ++i) {
                if (removedChildren[i] instanceof FloatingPane) continue;
                primaryContentChanged = true;
                break;
            }
        }
        if (primaryContentChanged) {
            this.renderDisposeDirective(rc, (ContentPane)update.getParent());
        }
        this.renderRemoveChildren(rc, update);
        this.renderAddChildren(rc, update);
        if (primaryContentChanged) {
            this.renderInitDirective(rc, (ContentPane)update.getParent());
        }
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        if ("horizontalScroll".equals(propertyElement.getAttribute("name"))) {
            Extent newValue = ExtentRender.toExtent(propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "horizontalScroll", newValue);
        } else if ("verticalScroll".equals(propertyElement.getAttribute("name"))) {
            Extent newValue = ExtentRender.toExtent(propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "verticalScroll", newValue);
        }
    }

    static {
        WebRenderServlet.getServiceRegistry().add(CONTENT_PANE_SERVICE);
    }
}

