/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.propertyrender;

import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.webrender.output.CssStyle;

public class ColorRender {
    private static final String COLOR_MASK = "#000000";

    public static void renderToStyle(CssStyle cssStyle, Color foreground, Color background) {
        if (foreground != null) {
            cssStyle.setAttribute("color", ColorRender.renderCssAttributeValue(foreground));
        }
        if (background != null) {
            cssStyle.setAttribute("background-color", ColorRender.renderCssAttributeValue(background));
        }
    }

    public static void renderToStyle(CssStyle cssStyle, Component component) {
        ColorRender.renderToStyle(cssStyle, (Color)component.getRenderProperty("foreground"), (Color)component.getRenderProperty("background"));
    }

    public static final String renderCssAttributeValue(Color color) {
        if (color == null) {
            return "";
        }
        int rgb = color.getRgb();
        String colorString = Integer.toString(rgb, 16);
        return COLOR_MASK.substring(0, 7 - colorString.length()) + colorString;
    }

    private ColorRender() {
    }
}

