/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.image;

import java.io.IOException;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.StreamImageReference;
import nextapp.echo2.webcontainer.image.AbstractImageService;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.WebRenderServlet;

public class StreamImageService
extends AbstractImageService {
    private static final String SERVICE_ID = "Echo.StreamImage";
    public static final StreamImageService INSTANCE = new StreamImageService();

    @Override
    public String getId() {
        return SERVICE_ID;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void renderImage(Connection conn, ImageReference imageReference) throws IOException {
        try {
            if (!(imageReference instanceof StreamImageReference)) {
                throw new IOException("Image is not a StreamImageReference.");
            }
            StreamImageReference streamImageReference = (StreamImageReference)imageReference;
            conn.setContentType(new ContentType(streamImageReference.getContentType(), true));
            streamImageReference.render(conn.getOutputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        WebRenderServlet.getServiceRegistry().add(INSTANCE);
    }
}

