/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.image;

import java.io.IOException;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.Service;

public abstract class AbstractImageService
implements Service {
    private static final String PARAMETER_IMAGE_UID = "imageuid";
    private static final String[] URL_PARAMETERS = new String[]{"imageuid"};

    public String createUri(ContainerInstance containerInstance, String imageId) {
        return containerInstance.getServiceUri(this, URL_PARAMETERS, new String[]{imageId});
    }

    public abstract void renderImage(Connection var1, ImageReference var2) throws IOException;

    @Override
    public void service(Connection conn) throws IOException {
        ContainerInstance containerInstance = (ContainerInstance)conn.getUserInstance();
        if (containerInstance == null) {
            this.serviceBadRequest(conn, "No container available.");
            return;
        }
        String imageId = conn.getRequest().getParameter(PARAMETER_IMAGE_UID);
        if (imageId == null) {
            this.serviceBadRequest(conn, "Image UID not specified.");
            return;
        }
        ImageReference imageReference = (ImageReference)containerInstance.getIdTable().getObject(imageId);
        if (imageReference == null) {
            this.serviceBadRequest(conn, "Image UID is not valid.");
            return;
        }
        this.renderImage(conn, imageReference);
    }

    public void serviceBadRequest(Connection conn, String message) {
        conn.getResponse().setStatus(400);
        conn.setContentType(ContentType.TEXT_PLAIN);
        conn.getWriter().write(message);
    }
}

