/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.filetransfer;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import nextapp.echo2.app.filetransfer.UploadSelect;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.filetransfer.MultipartUploadFactory;
import nextapp.echo2.webcontainer.filetransfer.MultipartUploadSPI;
import nextapp.echo2.webcontainer.filetransfer.UploadFormService;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;

public class UploadReceiver
implements Serializable,
Service {
    private static final String SERVICE_ID = "Echo.Upload";
    private static final String PARAMETER_UPLOAD_UID = "uploaduid";
    private static final String[] URL_PARAMETERS = new String[]{"uploaduid"};
    public static final UploadReceiver INSTANCE = new UploadReceiver();

    public String createUri(ContainerInstance containerInstance, String imageId) {
        return containerInstance.getServiceUri(this, URL_PARAMETERS, new String[]{imageId});
    }

    @Override
    public String getId() {
        return SERVICE_ID;
    }

    @Override
    public int getVersion() {
        return -1;
    }

    @Override
    public void service(Connection conn) throws IOException {
        ContainerInstance containerInstance = (ContainerInstance)conn.getUserInstance();
        if (containerInstance == null) {
            this.serviceBadRequest(conn, "No container available.");
            return;
        }
        String uploadId = conn.getRequest().getParameter(PARAMETER_UPLOAD_UID);
        if (uploadId == null) {
            this.serviceBadRequest(conn, "Upload UID not specified.");
            return;
        }
        UploadSelect upload = (UploadSelect)containerInstance.getIdTable().getObject(uploadId);
        if (upload == null) {
            this.serviceBadRequest(conn, "Upload UID is not valid: " + uploadId);
            return;
        }
        this.service(conn, upload);
    }

    protected void service(Connection conn, UploadSelect uploadSelect) throws IOException {
        ContainerInstance instance = (ContainerInstance)conn.getUserInstance();
        MultipartUploadSPI provider = MultipartUploadFactory.getMultipartUploadSPI();
        try {
            provider.updateComponent(conn, uploadSelect);
            String id = uploadSelect.getRenderId();
            conn.getResponse().sendRedirect(UploadFormService.INSTANCE.createUri(instance, id));
        }
        catch (ServletException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void serviceBadRequest(Connection conn, String message) {
        conn.getResponse().setStatus(400);
        conn.setContentType(ContentType.TEXT_PLAIN);
        conn.getWriter().write(message);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(INSTANCE);
    }
}

