/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.filetransfer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.http.HttpServletResponse;
import nextapp.echo2.app.filetransfer.DownloadProvider;
import nextapp.echo2.app.filetransfer.FilePane;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;

class FilePaneService
implements Service,
Serializable {
    private static final String SERVICE_ID = "Echo.FilePane";
    private static final String PARAMETER_COMPONENT_ID = "componentid";
    private static final String[] URL_PARAMETERS = new String[]{"componentid"};
    public static final FilePaneService INSTANCE = new FilePaneService();

    FilePaneService() {
    }

    public String createUri(ContainerInstance containerInstance, String componentId) {
        return containerInstance.getServiceUri(this, URL_PARAMETERS, new String[]{componentId});
    }

    @Override
    public String getId() {
        return SERVICE_ID;
    }

    @Override
    public int getVersion() {
        return -1;
    }

    @Override
    public void service(Connection conn) throws IOException {
        ContainerInstance containerInstance = (ContainerInstance)conn.getUserInstance();
        if (containerInstance == null) {
            this.serviceBadRequest(conn, "No container available.");
            return;
        }
        String componentId = conn.getRequest().getParameter(PARAMETER_COMPONENT_ID);
        if (componentId == null) {
            this.serviceBadRequest(conn, "Component UID not specified.");
            return;
        }
        FilePane filePane = (FilePane)containerInstance.getComponentByElementId(componentId);
        this.service(conn, filePane);
    }

    public void service(Connection conn, FilePane filePane) throws IOException {
        String contentType;
        OutputStream out = conn.getOutputStream();
        DownloadProvider provider = filePane.getProvider();
        HttpServletResponse response = conn.getResponse();
        if (provider.getSize() > 0) {
            response.setIntHeader("Content-Length", provider.getSize());
        }
        if ((contentType = provider.getContentType()) == null) {
            response.setContentType("application/octet-stream");
        } else {
            response.setContentType(provider.getContentType());
        }
        provider.writeFile(out);
    }

    public void serviceBadRequest(Connection conn, String message) {
        conn.getResponse().setStatus(400);
        conn.setContentType(ContentType.TEXT_PLAIN);
        conn.getWriter().write(message);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(INSTANCE);
    }
}

