/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.filetransfer;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.filetransfer.Download;
import nextapp.echo2.webcontainer.CommandSynchronizePeer;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.filetransfer.DownloadService;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class DownloadPeer
implements CommandSynchronizePeer,
Serializable {
    private static final Map ID_TO_DOWNLOAD_MAP = Collections.synchronizedMap(new HashMap());
    public static final Service DOWNLOAD_SERVICE = JavaScriptService.forResource("Echo.DownloadComponent", "/nextapp/echo2/webcontainer/filetransfer/resource/js/Download.js");

    @Override
    public void render(RenderContext rc, Command command) {
        Download download = (Download)command;
        if (download.isActive()) {
            ServerMessage serverMessage = rc.getServerMessage();
            serverMessage.addLibrary(DOWNLOAD_SERVICE.getId());
            String id = download.getRenderId();
            ID_TO_DOWNLOAD_MAP.put(id, download);
            String serviceUri = DownloadService.INSTANCE.createUri(rc.getContainerInstance(), id);
            Element itemizedUpdateElement = serverMessage.getItemizedDirective("update", "EchoDownloadComponent.MessageProcessor", "init", new String[0], new String[0]);
            Element itemElement = serverMessage.getDocument().createElement("echoDownload");
            itemElement.setAttribute("serviceUri", serviceUri);
            itemizedUpdateElement.appendChild(itemElement);
            download.setActive(false);
        }
    }

    static Download getDownload(String id) {
        return (Download)ID_TO_DOWNLOAD_MAP.get(id);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(DOWNLOAD_SERVICE);
    }
}

