/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.webcontainer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.StreamImageReference;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.extras.app.TransitionPane;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class TransitionPanePeer
implements ComponentSynchronizePeer {
    private PartialUpdateParticipant placeholderUpdateParticipant = new PartialUpdateParticipant(){

        @Override
        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
        }

        @Override
        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }
    };
    public static final Service TRANSITION_PANE_SERVICE = JavaScriptService.forResource("Echo2Extras.TransitionPane", "/nextapp/echo2/extras/webcontainer/resource/js/TransitionPane.js");
    private static final Map IMAGE_ID_TO_RESOURCE = new HashMap();
    public static final Service IMAGE_SERVICE;
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public TransitionPanePeer() {
        this.partialUpdateManager.add("type", this.placeholderUpdateParticipant);
        this.partialUpdateManager.add("duration", this.placeholderUpdateParticipant);
    }

    @Override
    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_content_" + child.getRenderId();
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(TRANSITION_PANE_SERVICE.getId());
        TransitionPane transitionPane = (TransitionPane)component;
        this.renderInitDirective(rc, transitionPane, targetId);
        if (transitionPane.getVisibleComponentCount() > 0) {
            Component child = transitionPane.getVisibleComponent(0);
            this.renderAddChild(rc, update, transitionPane, child);
        }
    }

    private void renderAddChild(RenderContext rc, ServerComponentUpdate update, TransitionPane transitionPane, Component child) {
        String elementId = ContainerInstance.getElementId(transitionPane);
        Element addChildElement = rc.getServerMessage().appendPartDirective("update", "ExtrasTransitionPane.MessageProcessor", "add-child");
        addChildElement.setAttribute("eid", elementId);
        addChildElement.setAttribute("child-id", child.getRenderId());
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(TRANSITION_PANE_SERVICE.getId());
        this.renderDisposeDirective(rc, (TransitionPane)component);
    }

    private void renderDisposeDirective(RenderContext rc, TransitionPane transitionPane) {
        String elementId = ContainerInstance.getElementId(transitionPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "ExtrasTransitionPane.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    private String getTransitionTypeString(TransitionPane transitionPane) {
        Integer transitionType = (Integer)transitionPane.getProperty("type");
        if (transitionType != null) {
            switch (transitionType) {
                case 1: {
                    return "camera-pan-left";
                }
                case 2: {
                    return "camera-pan-right";
                }
                case 3: {
                    return "camera-pan-up";
                }
                case 4: {
                    return "camera-pan-down";
                }
                case 5: {
                    return "blind-black-in";
                }
                case 6: {
                    return "blind-black-out";
                }
                case 7: {
                    return "fade-to-black";
                }
                case 8: {
                    return "fade-to-white";
                }
                case 9: {
                    return "fade";
                }
            }
        }
        return null;
    }

    private void renderInitDirective(RenderContext rc, TransitionPane transitionPane, String targetId) {
        String elementId = ContainerInstance.getElementId(transitionPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("update", "ExtrasTransitionPane.MessageProcessor");
        Element initElement = serverMessage.getDocument().createElement("init");
        initElement.setAttribute("container-eid", targetId);
        initElement.setAttribute("eid", elementId);
        String type = this.getTransitionTypeString(transitionPane);
        if (type != null) {
            initElement.setAttribute("type", type);
        }
        partElement.appendChild(initElement);
    }

    private void renderRemoveChild(RenderContext rc, ServerComponentUpdate update, TransitionPane transitionPane, Component child) {
        String elementId = ContainerInstance.getElementId(transitionPane);
        Element removeChildElement = rc.getServerMessage().appendPartDirective("remove", "ExtrasTransitionPane.MessageProcessor", "remove-child");
        removeChildElement.setAttribute("eid", elementId);
        removeChildElement.setAttribute("child-id", child.getRenderId());
    }

    private void renderUpdateDirective(RenderContext rc, ServerComponentUpdate update, TransitionPane transitionPane) {
        Integer duration;
        String elementId = ContainerInstance.getElementId(transitionPane);
        Element updateElement = rc.getServerMessage().appendPartDirective("update", "ExtrasTransitionPane.MessageProcessor", "update");
        updateElement.setAttribute("eid", elementId);
        String type = this.getTransitionTypeString(transitionPane);
        if (type != null) {
            updateElement.setAttribute("type", type);
        }
        if ((duration = (Integer)transitionPane.getRenderProperty("duration")) != null) {
            updateElement.setAttribute("duration", duration.toString());
        }
    }

    private void renderTransitionDirective(RenderContext rc, ServerComponentUpdate update, TransitionPane transitionPane) {
        String elementId = ContainerInstance.getElementId(transitionPane);
        Element transitionElement = rc.getServerMessage().appendPartDirective("postupdate", "ExtrasTransitionPane.MessageProcessor", "transition");
        transitionElement.setAttribute("eid", elementId);
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        TransitionPane transitionPane = (TransitionPane)update.getParent();
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            int i;
            if (update.hasUpdatedProperties()) {
                this.partialUpdateManager.process(rc, update);
                String[] propertyNames = update.getUpdatedPropertyNames();
                for (i = 0; i < propertyNames.length; ++i) {
                    if (!"duration".equals(propertyNames[i]) && !"type".equals(propertyNames[i])) continue;
                    this.renderUpdateDirective(rc, update, transitionPane);
                    break;
                }
            }
            if (update.hasRemovedChildren() || update.hasAddedChildren()) {
                if (update.hasRemovedChildren()) {
                    Component[] removedChildren = update.getRemovedChildren();
                    for (i = 0; i < removedChildren.length; ++i) {
                        this.renderRemoveChild(rc, update, transitionPane, removedChildren[i]);
                    }
                }
                if (update.hasAddedChildren()) {
                    Component[] addedChildren = update.getAddedChildren();
                    if (addedChildren.length > 1) {
                        throw new IllegalStateException("Multiple added children.:");
                    }
                    this.renderAddChild(rc, update, transitionPane, addedChildren[0]);
                }
                this.renderTransitionDirective(rc, update, transitionPane);
            }
        }
        return fullReplace;
    }

    static {
        for (int i = 1; i <= 16; ++i) {
            IMAGE_ID_TO_RESOURCE.put("blind-black-" + i, new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/blindblack/Frame" + i + ".gif"));
        }
        IMAGE_ID_TO_RESOURCE.put("fade-000000-927", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_000000/Alpha927.png"));
        IMAGE_ID_TO_RESOURCE.put("fade-000000-787", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_000000/Alpha787.png"));
        IMAGE_ID_TO_RESOURCE.put("fade-000000-700", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_000000/Alpha700.png"));
        IMAGE_ID_TO_RESOURCE.put("fade-000000-420", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_000000/Alpha420.png"));
        IMAGE_ID_TO_RESOURCE.put("fade-000000-230", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_000000/Alpha230.png"));
        IMAGE_ID_TO_RESOURCE.put("fade-ffffff-927", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_ffffff/Alpha927.png"));
        IMAGE_ID_TO_RESOURCE.put("fade-ffffff-787", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_ffffff/Alpha787.png"));
        IMAGE_ID_TO_RESOURCE.put("fade-ffffff-700", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_ffffff/Alpha700.png"));
        IMAGE_ID_TO_RESOURCE.put("fade-ffffff-420", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_ffffff/Alpha420.png"));
        IMAGE_ID_TO_RESOURCE.put("fade-ffffff-230", new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/transition/fade_ffffff/Alpha230.png"));
        IMAGE_SERVICE = new Service(){

            @Override
            public String getId() {
                return "Echo2Extras.TransitionPane.Image";
            }

            @Override
            public int getVersion() {
                return 0;
            }

            @Override
            public void service(Connection conn) throws IOException {
                String imageId = conn.getRequest().getParameter("imageId");
                StreamImageReference imageReference = (StreamImageReference)IMAGE_ID_TO_RESOURCE.get(imageId);
                conn.setContentType(new ContentType(imageReference.getContentType(), true));
                imageReference.render(conn.getOutputStream());
            }
        };
        WebRenderServlet.getServiceRegistry().add(TRANSITION_PANE_SERVICE);
        WebRenderServlet.getServiceRegistry().add(IMAGE_SERVICE);
    }
}

