/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.webcontainer;

import java.util.HashSet;
import java.util.Set;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Pane;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.extras.app.TabPane;
import nextapp.echo2.extras.app.layout.TabPaneLayoutData;
import nextapp.echo2.extras.webcontainer.ExtrasUtil;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.LazyRenderContainer;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class TabPanePeer
implements ComponentSynchronizePeer,
ImageRenderSupport,
LazyRenderContainer,
PropertyUpdateProcessor {
    private static final String IMAGE_ID_TAB_ACTIVE_BACKGROUND = "tabActiveBackground";
    private static final String IMAGE_ID_TAB_INACTIVE_BACKGROUND = "tabInactiveBackground";
    private static final String PROPERTY_ACTIVE_TAB = "activeTab";
    public static final String PROPERTY_LAZY_RENDER_ENABLED = "nextapp.echo2.extras.webcontainer.TabPanePeer.lazyRenderEnabled";
    public static final Service TAB_PANE_SERVICE = JavaScriptService.forResource("Echo2Extras.TabPane", "/nextapp/echo2/extras/webcontainer/resource/js/TabPane.js");
    private PartialUpdateParticipant activeTabUpdateParticipant = new PartialUpdateParticipant(){

        @Override
        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
            TabPanePeer.this.renderSetActiveTab(rc, update, (TabPane)update.getParent());
        }

        @Override
        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }
    };
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public TabPanePeer() {
        this.partialUpdateManager.add("activeTabIndex", this.activeTabUpdateParticipant);
    }

    private String getRenderedActiveTabId(ContainerInstance ci, TabPane tabPane) {
        TabPaneRenderState renderState = (TabPaneRenderState)ci.getRenderState(tabPane);
        return renderState.activeTabId;
    }

    private boolean configureActiveTab(ContainerInstance ci, TabPane tabPane) {
        Component activeTab;
        TabPaneRenderState renderState = (TabPaneRenderState)ci.getRenderState(tabPane);
        int componentCount = tabPane.getVisibleComponentCount();
        int activeTabIndex = tabPane.getActiveTabIndex();
        Component component = activeTab = activeTabIndex >= 0 && activeTabIndex < componentCount ? tabPane.getComponent(activeTabIndex) : null;
        if (activeTab == null && renderState.activeTabId != null) {
            activeTab = this.getChildByRenderId(tabPane, renderState.activeTabId);
        }
        if (activeTab == null) {
            if (componentCount == 0) {
                return false;
            }
            activeTab = tabPane.getActiveTabIndex() == -1 ? tabPane.getVisibleComponent(0) : tabPane.getVisibleComponent(componentCount - 1);
        }
        renderState.activeTabId = activeTab.getRenderId();
        if (this.isLazyRenderEnabled(tabPane)) {
            if (!this.isRendered(ci, tabPane, activeTab)) {
                this.setRendered(ci, tabPane, activeTab);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_content_" + child.getRenderId();
    }

    private Component getChildByRenderId(TabPane tabPane, String renderId) {
        Component[] children = tabPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getRenderId().equals(renderId)) continue;
            return children[i];
        }
        return null;
    }

    @Override
    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_TAB_ACTIVE_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("tabActiveBackgroundImage");
            return backgroundImage == null ? null : backgroundImage.getImage();
        }
        if (IMAGE_ID_TAB_INACTIVE_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("tabInactiveBackgroundImage");
            return backgroundImage == null ? null : backgroundImage.getImage();
        }
        return null;
    }

    private boolean isLazyRenderEnabled(TabPane tabPane) {
        Boolean lazyRenderEnabled = (Boolean)tabPane.getRenderProperty(PROPERTY_LAZY_RENDER_ENABLED);
        return lazyRenderEnabled == null ? true : lazyRenderEnabled;
    }

    @Override
    public boolean isRendered(ContainerInstance ci, Component parent, Component child) {
        if (!this.isLazyRenderEnabled((TabPane)parent)) {
            return true;
        }
        TabPaneRenderState renderState = (TabPaneRenderState)ci.getRenderState(parent);
        if (renderState == null) {
            return false;
        }
        return renderState.renderedChildren.contains(child);
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if (PROPERTY_ACTIVE_TAB.equals(propertyName)) {
            String propertyValue = propertyElement.getAttribute("value");
            Component[] children = component.getVisibleComponents();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].getRenderId().equals(propertyValue)) continue;
                ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "inputTabIndex", new Integer(i));
                return;
            }
        }
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(TAB_PANE_SERVICE.getId());
        serverMessage.addLibrary(ExtrasUtil.JS_EXTRAS_UTIL_SERVICE.getId());
        TabPane tabPane = (TabPane)component;
        ContainerInstance ci = rc.getContainerInstance();
        this.resetRenderState(ci, tabPane);
        this.configureActiveTab(ci, tabPane);
        this.renderInitDirective(rc, tabPane, targetId);
        Component[] children = tabPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            this.renderAddTabDirective(rc, update, tabPane, children[i]);
        }
        boolean lazyRenderEnabled = this.isLazyRenderEnabled(tabPane);
        for (int i = 0; i < children.length; ++i) {
            if (lazyRenderEnabled && !this.isRendered(ci, tabPane, children[i])) continue;
            this.renderChild(rc, update, tabPane, children[i]);
        }
    }

    private void renderAddChildren(RenderContext rc, ServerComponentUpdate update, boolean activeTabRenderRequired) {
        TabPaneRenderState renderState;
        TabPane tabPane = (TabPane)update.getParent();
        ContainerInstance ci = rc.getContainerInstance();
        Component activeTab = null;
        if (activeTabRenderRequired && (activeTab = this.getChildByRenderId(tabPane, (renderState = (TabPaneRenderState)ci.getRenderState(tabPane)).activeTabId)) == null) {
            activeTabRenderRequired = false;
        }
        if (update.hasAddedChildren()) {
            Component[] addedChildren = update.getAddedChildren();
            Component[] children = tabPane.getVisibleComponents();
            block0: for (int i = 0; i < children.length; ++i) {
                for (int j = 0; j < addedChildren.length; ++j) {
                    if (children[i] != addedChildren[j]) continue;
                    this.renderAddTabDirective(rc, update, tabPane, children[i]);
                    continue block0;
                }
            }
            boolean lazyRenderEnabled = this.isLazyRenderEnabled(tabPane);
            for (int i = 0; i < addedChildren.length; ++i) {
                if (lazyRenderEnabled && !this.isRendered(ci, tabPane, addedChildren[i])) continue;
                this.renderChild(rc, update, tabPane, addedChildren[i]);
                if (addedChildren[i] != activeTab) continue;
                activeTabRenderRequired = false;
            }
        }
        if (activeTabRenderRequired) {
            this.renderChild(rc, update, tabPane, activeTab);
        }
    }

    private void renderAddTabDirective(RenderContext rc, ServerComponentUpdate update, TabPane tabPane, Component child) {
        ContainerInstance ci = rc.getContainerInstance();
        boolean rendered = !this.isLazyRenderEnabled(tabPane) || this.isRendered(ci, tabPane, child);
        TabPaneLayoutData layoutData = (TabPaneLayoutData)child.getLayoutData();
        String elementId = ContainerInstance.getElementId(tabPane);
        Element addPartElement = rc.getServerMessage().appendPartDirective("update", "ExtrasTabPane.MessageProcessor", "add-tab");
        addPartElement.setAttribute("eid", elementId);
        addPartElement.setAttribute("tab-id", child.getRenderId());
        addPartElement.setAttribute("tab-index", Integer.toString(tabPane.indexOf(child)));
        if (rendered) {
            addPartElement.setAttribute("rendered", "true");
        }
        if (child instanceof Pane) {
            addPartElement.setAttribute("pane", "true");
        }
        if (layoutData != null && layoutData.getTitle() != null) {
            addPartElement.setAttribute("title", layoutData.getTitle());
        }
    }

    private void renderChild(RenderContext rc, ServerComponentUpdate update, TabPane tabPane, Component child) {
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(TAB_PANE_SERVICE.getId());
        serverMessage.addLibrary(ExtrasUtil.JS_EXTRAS_UTIL_SERVICE.getId());
        this.renderDisposeDirective(rc, (TabPane)component);
    }

    private void renderDisposeDirective(RenderContext rc, TabPane tabPane) {
        String elementId = ContainerInstance.getElementId(tabPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "ExtrasTabPane.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    private void renderInitDirective(RenderContext rc, TabPane tabPane, String targetId) {
        String activeTabId;
        Color tabInactiveForeground;
        Font tabInactiveFont;
        Border tabInactiveBorder;
        FillImage tabInactiveBackgroundImage;
        Color tabInactiveBackground;
        Color tabActiveForeground;
        Font tabActiveFont;
        Border tabActiveBorder;
        FillImage tabActiveBackgroundImage;
        Color tabActiveBackground;
        Integer borderType;
        Integer tabPosition;
        Extent tabSpacing;
        Extent tabInset;
        Insets insets;
        Insets defaultContentInsets;
        Color foreground;
        Color background;
        String elementId = ContainerInstance.getElementId(tabPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("update", "ExtrasTabPane.MessageProcessor");
        Element initElement = serverMessage.getDocument().createElement("init");
        initElement.setAttribute("container-eid", targetId);
        initElement.setAttribute("eid", elementId);
        if (!tabPane.isRenderEnabled()) {
            initElement.setAttribute("enabled", "false");
        }
        if ((background = (Color)tabPane.getRenderProperty("background")) != null) {
            initElement.setAttribute("default-background", ColorRender.renderCssAttributeValue(background));
        }
        if ((foreground = (Color)tabPane.getRenderProperty("foreground")) != null) {
            initElement.setAttribute("default-foreground", ColorRender.renderCssAttributeValue(foreground));
        }
        if ((defaultContentInsets = (Insets)tabPane.getRenderProperty("defaultContentInsets")) != null) {
            initElement.setAttribute("default-content-insets", InsetsRender.renderCssAttributeValue(defaultContentInsets));
        }
        if ((insets = (Insets)tabPane.getRenderProperty("insets")) != null) {
            initElement.setAttribute("insets", InsetsRender.renderCssAttributeValue(insets));
        }
        if ((tabInset = (Extent)tabPane.getRenderProperty("tabInset")) != null) {
            initElement.setAttribute("tab-inset", ExtentRender.renderCssAttributeValue(tabInset));
        }
        if ((tabSpacing = (Extent)tabPane.getRenderProperty("tabSpacing")) != null) {
            initElement.setAttribute("tab-spacing", ExtentRender.renderCssAttributeValue(tabSpacing));
        }
        if ((tabPosition = (Integer)tabPane.getRenderProperty("tabPosition")) != null) {
            initElement.setAttribute("tab-position", tabPosition == 1 ? "bottom" : "top");
        }
        if ((borderType = (Integer)tabPane.getRenderProperty("borderType")) != null) {
            switch (borderType) {
                case 1: {
                    initElement.setAttribute("border-type", "adjacent");
                    break;
                }
                case 0: {
                    initElement.setAttribute("border-type", "none");
                    break;
                }
                case 2: {
                    initElement.setAttribute("border-type", "parallel");
                    break;
                }
                case 3: {
                    initElement.setAttribute("border-type", "surround");
                }
            }
        }
        if ((tabActiveBackground = (Color)tabPane.getRenderProperty(IMAGE_ID_TAB_ACTIVE_BACKGROUND)) != null) {
            initElement.setAttribute("tab-active-background", ColorRender.renderCssAttributeValue(tabActiveBackground));
        }
        if ((tabActiveBackgroundImage = (FillImage)tabPane.getRenderProperty("tabActiveBackgroundImage")) != null) {
            CssStyle backgroundImageStyle = new CssStyle();
            FillImageRender.renderToStyle(backgroundImageStyle, rc, this, tabPane, IMAGE_ID_TAB_ACTIVE_BACKGROUND, tabActiveBackgroundImage, 0);
            initElement.setAttribute("tab-active-background-image", backgroundImageStyle.renderInline());
        }
        if ((tabActiveBorder = (Border)tabPane.getRenderProperty("tabActiveBorder")) != null) {
            if (tabActiveBorder.getColor() != null) {
                initElement.setAttribute("tab-active-border-color", ColorRender.renderCssAttributeValue(tabActiveBorder.getColor()));
            }
            if (tabActiveBorder.getSize() != null && tabActiveBorder.getSize().getUnits() == 1) {
                initElement.setAttribute("tab-active-border-size", Integer.toString(tabActiveBorder.getSize().getValue()));
            }
            initElement.setAttribute("tab-active-border-style", BorderRender.getStyleValue(tabActiveBorder.getStyle()));
        }
        if ((tabActiveFont = (Font)tabPane.getRenderProperty("tabActiveFont")) != null) {
            CssStyle fontStyle = new CssStyle();
            FontRender.renderToStyle(fontStyle, tabActiveFont);
            initElement.setAttribute("tab-active-font", fontStyle.renderInline());
        }
        if ((tabActiveForeground = (Color)tabPane.getRenderProperty("tabActiveForeground")) != null) {
            initElement.setAttribute("tab-active-foreground", ColorRender.renderCssAttributeValue(tabActiveForeground));
        }
        if ((tabInactiveBackground = (Color)tabPane.getRenderProperty(IMAGE_ID_TAB_INACTIVE_BACKGROUND)) != null) {
            initElement.setAttribute("tab-inactive-background", ColorRender.renderCssAttributeValue(tabInactiveBackground));
        }
        if ((tabInactiveBackgroundImage = (FillImage)tabPane.getRenderProperty("tabInactiveBackgroundImage")) != null) {
            CssStyle backgroundImageStyle = new CssStyle();
            FillImageRender.renderToStyle(backgroundImageStyle, rc, this, tabPane, IMAGE_ID_TAB_INACTIVE_BACKGROUND, tabInactiveBackgroundImage, 0);
            initElement.setAttribute("tab-inactive-background-image", backgroundImageStyle.renderInline());
        }
        if ((tabInactiveBorder = (Border)tabPane.getRenderProperty("tabInactiveBorder")) != null) {
            if (tabInactiveBorder.getColor() != null) {
                initElement.setAttribute("tab-inactive-border-color", ColorRender.renderCssAttributeValue(tabInactiveBorder.getColor()));
            }
            if (tabInactiveBorder.getSize() != null && tabInactiveBorder.getSize().getUnits() == 1) {
                initElement.setAttribute("tab-inactive-border-size", Integer.toString(tabInactiveBorder.getSize().getValue()));
            }
            initElement.setAttribute("tab-inactive-border-style", BorderRender.getStyleValue(tabInactiveBorder.getStyle()));
        }
        if ((tabInactiveFont = (Font)tabPane.getRenderProperty("tabInactiveFont")) != null) {
            CssStyle fontStyle = new CssStyle();
            FontRender.renderToStyle(fontStyle, tabInactiveFont);
            initElement.setAttribute("tab-inactive-font", fontStyle.renderInline());
        }
        if ((tabInactiveForeground = (Color)tabPane.getRenderProperty("tabInactiveForeground")) != null) {
            initElement.setAttribute("tab-inactive-foreground", ColorRender.renderCssAttributeValue(tabInactiveForeground));
        }
        if ((activeTabId = this.getRenderedActiveTabId(rc.getContainerInstance(), tabPane)) != null) {
            initElement.setAttribute("active-tab", activeTabId);
        }
        partElement.appendChild(initElement);
    }

    private void renderRemoveChildren(RenderContext rc, ServerComponentUpdate update) {
        TabPane tabPane = (TabPane)update.getParent();
        Component[] removedChildren = update.getRemovedChildren();
        for (int i = 0; i < removedChildren.length; ++i) {
            this.renderRemoveTabDirective(rc, update, tabPane, removedChildren[i]);
        }
    }

    private void renderRemoveTabDirective(RenderContext rc, ServerComponentUpdate update, TabPane tabPane, Component child) {
        String elementId = ContainerInstance.getElementId(tabPane);
        Element removeTabElement = rc.getServerMessage().appendPartDirective("remove", "ExtrasTabPane.MessageProcessor", "remove-tab");
        removeTabElement.setAttribute("eid", elementId);
        removeTabElement.setAttribute("tab-id", child.getRenderId());
    }

    private void renderSetActiveTab(RenderContext rc, ServerComponentUpdate update, TabPane tabPane) {
        TabPaneRenderState renderState;
        ContainerInstance ci = rc.getContainerInstance();
        boolean activeTabRenderRequired = this.configureActiveTab(ci, tabPane);
        Component activeTab = null;
        if (activeTabRenderRequired && (activeTab = this.getChildByRenderId(tabPane, (renderState = (TabPaneRenderState)ci.getRenderState(tabPane)).activeTabId)) != null) {
            this.renderChild(rc, update, tabPane, activeTab);
        }
        this.renderSetActiveTabDirective(rc, update, tabPane);
    }

    private void renderSetActiveTabDirective(RenderContext rc, ServerComponentUpdate update, TabPane tabPane) {
        Component activeTab = null;
        TabPaneRenderState renderState = (TabPaneRenderState)rc.getContainerInstance().getRenderState(tabPane);
        activeTab = this.getChildByRenderId(tabPane, renderState.activeTabId);
        if (activeTab == null) {
            return;
        }
        String elementId = ContainerInstance.getElementId(tabPane);
        Element setActiveTabElement = rc.getServerMessage().appendPartDirective("update", "ExtrasTabPane.MessageProcessor", "set-active-tab");
        setActiveTabElement.setAttribute("eid", elementId);
        setActiveTabElement.setAttribute("active-tab", activeTab.getRenderId());
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        ContainerInstance ci = rc.getContainerInstance();
        TabPane tabPane = (TabPane)update.getParent();
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            if (update.hasRemovedChildren() || update.hasAddedChildren()) {
                boolean activeTabRenderRequired = this.configureActiveTab(ci, tabPane);
                if (update.hasRemovedChildren()) {
                    this.renderRemoveChildren(rc, update);
                }
                if (update.hasAddedChildren() || activeTabRenderRequired) {
                    this.renderAddChildren(rc, update, activeTabRenderRequired);
                }
                this.renderSetActiveTabDirective(rc, update, tabPane);
            }
            if (update.hasUpdatedProperties()) {
                this.partialUpdateManager.process(rc, update);
            }
        }
        return fullReplace;
    }

    private void resetRenderState(ContainerInstance ci, TabPane tabPane) {
        TabPaneRenderState renderState = new TabPaneRenderState();
        ci.setRenderState(tabPane, renderState);
    }

    private void setRendered(ContainerInstance ci, TabPane tabPane, Component child) {
        TabPaneRenderState renderState = (TabPaneRenderState)ci.getRenderState(tabPane);
        if (renderState == null) {
            renderState = new TabPaneRenderState();
            ci.setRenderState(tabPane, renderState);
        }
        renderState.renderedChildren.add(child);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(TAB_PANE_SERVICE);
    }

    private static class TabPaneRenderState
    implements RenderState {
        private String activeTabId;
        private Set renderedChildren = new HashSet();

        private TabPaneRenderState() {
        }
    }
}

