/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.webcontainer;

import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.extras.app.DropDownMenu;
import nextapp.echo2.extras.app.menu.ItemModel;
import nextapp.echo2.extras.app.menu.MenuSelectionModel;
import nextapp.echo2.extras.webcontainer.AbstractMenuPeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.image.ImageTools;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Element;

public class DropDownMenuPeer
extends AbstractMenuPeer {
    static final ImageReference DEFAULT_ICON_EXPAND = new ResourceImageReference("/nextapp/echo2/extras/webcontainer/resource/image/ArrowDown.gif");
    public static final String IMAGE_ID_DISABLED_EXPAND_ICON = "disabledExpandIcon";
    public static final String IMAGE_ID_EXPAND_ICON = "expandIcon";

    @Override
    public ImageReference getImage(Component component, String imageId) {
        ImageReference image = super.getImage(component, imageId);
        if (image != null) {
            return image;
        }
        FillImage fillImage = null;
        if ("background".equals(imageId)) {
            fillImage = (FillImage)component.getRenderProperty("backgroundImage");
            return fillImage == null ? null : fillImage.getImage();
        }
        if ("menuBackground".equals(imageId)) {
            fillImage = (FillImage)component.getRenderProperty("menuBackgroundImage");
            return fillImage == null ? null : fillImage.getImage();
        }
        if ("selectionBackground".equals(imageId)) {
            fillImage = (FillImage)component.getRenderProperty("selectionBackgroundImage");
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_EXPAND_ICON.equals(imageId)) {
            return (ImageReference)component.getRenderProperty(IMAGE_ID_EXPAND_ICON, DEFAULT_ICON_EXPAND);
        }
        if (IMAGE_ID_DISABLED_EXPAND_ICON.equals(imageId)) {
            return (ImageReference)component.getRenderProperty(IMAGE_ID_DISABLED_EXPAND_ICON);
        }
        return null;
    }

    @Override
    void renderDisposeDirective(RenderContext rc, Component component) {
        DropDownMenu menu = (DropDownMenu)component;
        String elementId = ContainerInstance.getElementId(menu);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "ExtrasDropDownMenu.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    @Override
    void renderInitDirective(RenderContext rc, Component component, String targetId) {
        Color disabledForeground;
        FillImage disabledBackgroundImage;
        Color disabledBackground;
        Color selectionForeground;
        FillImage selectionBackgroundImage;
        Color selectionBackground;
        FillImage menuBackgroundImage;
        Color menuBackground;
        Extent width;
        Extent height;
        Color foreground;
        FillImage backgroundImage;
        Color background;
        MenuSelectionModel selectionModel;
        DropDownMenu menu = (DropDownMenu)component;
        String elementId = ContainerInstance.getElementId(menu);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("update", "ExtrasDropDownMenu.MessageProcessor");
        Element initElement = serverMessage.getDocument().createElement("init");
        initElement.setAttribute("container-eid", targetId);
        initElement.setAttribute("eid", elementId);
        if (!menu.isRenderEnabled()) {
            initElement.setAttribute("enabled", "false");
        }
        if ((selectionModel = menu.getSelectionModel()) != null) {
            ItemModel selectedModel;
            initElement.setAttribute("selection", "true");
            String selectedId = selectionModel.getSelectedId();
            ItemModel itemModel = selectedModel = selectedId == null ? null : this.getItemModelById(menu, selectedId);
            if (selectedModel != null) {
                initElement.setAttribute("selected-path", this.getItemPath(menu.getModel(), selectedModel));
            }
        }
        if ((background = (Color)menu.getRenderProperty("background")) != null) {
            initElement.setAttribute("background", ColorRender.renderCssAttributeValue(background));
        }
        if ((backgroundImage = (FillImage)menu.getRenderProperty("backgroundImage")) != null) {
            CssStyle cssStyle = new CssStyle();
            FillImageRender.renderToStyle(cssStyle, rc, this, menu, "background", backgroundImage, 0);
            initElement.setAttribute("background-image", cssStyle.renderInline());
        }
        if ((foreground = (Color)menu.getRenderProperty("foreground")) != null) {
            initElement.setAttribute("foreground", ColorRender.renderCssAttributeValue(foreground));
        }
        if ((height = (Extent)menu.getRenderProperty("height")) != null) {
            initElement.setAttribute("height", ExtentRender.renderCssAttributeValue(height));
        }
        if ((width = (Extent)menu.getRenderProperty("width")) != null) {
            initElement.setAttribute("width", ExtentRender.renderCssAttributeValue(width));
        }
        if ((menuBackground = (Color)menu.getRenderProperty("menuBackground")) != null) {
            initElement.setAttribute("menu-background", ColorRender.renderCssAttributeValue(menuBackground));
        }
        if ((menuBackgroundImage = (FillImage)menu.getRenderProperty("menuBackgroundImage")) != null) {
            CssStyle cssStyle = new CssStyle();
            FillImageRender.renderToStyle(cssStyle, rc, this, menu, "menuBackground", menuBackgroundImage, 0);
            initElement.setAttribute("menu-background-image", cssStyle.renderInline());
        }
        if ((selectionBackground = (Color)menu.getRenderProperty("selectionBackground")) != null) {
            initElement.setAttribute("selection-background", ColorRender.renderCssAttributeValue(selectionBackground));
        }
        if ((selectionBackgroundImage = (FillImage)menu.getRenderProperty("selectionBackgroundImage")) != null) {
            CssStyle cssStyle = new CssStyle();
            FillImageRender.renderToStyle(cssStyle, rc, this, menu, "selectionBackground", selectionBackgroundImage, 0);
            initElement.setAttribute("selection-background-image", cssStyle.renderInline());
        }
        if ((selectionForeground = (Color)menu.getRenderProperty("selectionForeground")) != null) {
            initElement.setAttribute("selection-foreground", ColorRender.renderCssAttributeValue(selectionForeground));
        }
        if ((disabledBackground = (Color)menu.getRenderProperty("disabledBackground")) != null) {
            initElement.setAttribute("disabled-background", ColorRender.renderCssAttributeValue(disabledBackground));
        }
        if ((disabledBackgroundImage = (FillImage)menu.getRenderProperty("disabledBackgroundImage")) != null) {
            CssStyle cssStyle = new CssStyle();
            FillImageRender.renderToStyle(cssStyle, rc, this, menu, "disabledBackground", disabledBackgroundImage, 0);
            initElement.setAttribute("disabled-background-image", cssStyle.renderInline());
        }
        if ((disabledForeground = (Color)menu.getRenderProperty("disabledForeground")) != null) {
            initElement.setAttribute("disabled-foreground", ColorRender.renderCssAttributeValue(disabledForeground));
        }
        initElement.setAttribute("submenu-image", ImageTools.getUri(rc, this, menu, "submenuRight"));
        initElement.setAttribute("icon-toggle-off", ImageTools.getUri(rc, this, menu, "toggleOff"));
        initElement.setAttribute("icon-toggle-on", ImageTools.getUri(rc, this, menu, "toggleOn"));
        initElement.setAttribute("icon-radio-off", ImageTools.getUri(rc, this, menu, "radioOff"));
        initElement.setAttribute("icon-radio-on", ImageTools.getUri(rc, this, menu, "radioOn"));
        initElement.setAttribute("expand-icon", ImageTools.getUri(rc, this, menu, IMAGE_ID_EXPAND_ICON));
        if (menu.getRenderProperty(IMAGE_ID_DISABLED_EXPAND_ICON) != null) {
            initElement.setAttribute("disabled-expand-icon", ImageTools.getUri(rc, this, menu, IMAGE_ID_DISABLED_EXPAND_ICON));
        }
        this.renderModel(rc, menu, menu.getModel(), initElement);
        partElement.appendChild(initElement);
    }
}

